/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.FileHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class FileHeaderReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_FILE};

    protected FileHeaderReader() {
    }

    public boolean canFail() {
        return false;
    }

    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    public Chunk read(GUID guid, InputStream stream, long chunkStart) throws IOException {
        BigInteger chunkLen = Utils.readBig64(stream);
        stream.skip(16L);
        BigInteger fileSize = Utils.readBig64(stream);
        BigInteger fileTime = Utils.readBig64(stream);
        BigInteger packageCount = Utils.readBig64(stream);
        BigInteger timeEndPos = Utils.readBig64(stream);
        BigInteger duration = Utils.readBig64(stream);
        BigInteger timeStartPos = Utils.readBig64(stream);
        long flags = Utils.readUINT32(stream);
        long minPkgSize = Utils.readUINT32(stream);
        long maxPkgSize = Utils.readUINT32(stream);
        long uncompressedFrameSize = Utils.readUINT32(stream);
        FileHeader result = new FileHeader(chunkLen, fileSize, fileTime, packageCount, duration, timeStartPos, timeEndPos, flags, minPkgSize, maxPkgSize, uncompressedFrameSize);
        result.setPosition(chunkStart);
        return result;
    }
}

