/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.event.shared.testing;

import com.google.web.bindery.event.shared.Event;
import com.google.web.bindery.event.shared.EventBus;
import com.google.web.bindery.event.shared.HandlerRegistration;
import com.google.web.bindery.event.shared.SimpleEventBus;
import java.util.HashSet;
import java.util.Set;

public class RecordingEventBus
extends EventBus {
    private final Set<Event<?>> firedEvents = new HashSet();
    private final EventBus wrapped;

    public RecordingEventBus() {
        this(new SimpleEventBus());
    }

    public RecordingEventBus(EventBus wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public <H> HandlerRegistration addHandler(Event.Type<H> type, H handler) {
        return this.wrapped.addHandler(type, handler);
    }

    @Override
    public <H> HandlerRegistration addHandlerToSource(Event.Type<H> type, Object source, H handler) {
        return this.wrapped.addHandlerToSource(type, source, handler);
    }

    public void clearFiredEvents() {
        this.firedEvents.clear();
    }

    @Override
    public void fireEvent(Event<?> event) {
        this.wrapped.fireEvent(event);
        this.firedEvents.add(event);
    }

    @Override
    public void fireEventFromSource(Event<?> event, Object source) {
        this.firedEvents.add(event);
        this.wrapped.fireEventFromSource(event, source);
    }

    public boolean wasEventFired(Event<?> event) {
        return this.firedEvents.contains(event);
    }
}

