/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.rpc.impl;

import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.InvocationException;
import com.google.gwt.user.client.rpc.RpcTokenException;
import com.google.gwt.user.client.rpc.RpcTokenExceptionHandler;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamFactory;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.StatusCodeException;
import com.google.gwt.user.client.rpc.impl.RemoteServiceProxy;
import com.google.gwt.user.client.rpc.impl.RpcStatsContext;

public class RequestCallbackAdapter<T>
implements RequestCallback {
    private final AsyncCallback<T> callback;
    private final String methodName;
    private final RpcStatsContext statsContext;
    private final ResponseReader responseReader;
    private final RpcTokenExceptionHandler tokenExceptionHandler;
    private final SerializationStreamFactory streamFactory;

    public RequestCallbackAdapter(SerializationStreamFactory streamFactory, String methodName, RpcStatsContext statsContext, AsyncCallback<T> callback, ResponseReader responseReader) {
        this(streamFactory, methodName, statsContext, callback, null, responseReader);
    }

    public RequestCallbackAdapter(SerializationStreamFactory streamFactory, String methodName, RpcStatsContext statsContext, AsyncCallback<T> callback, RpcTokenExceptionHandler tokenExceptionHandler, ResponseReader responseReader) {
        assert (streamFactory != null);
        assert (callback != null);
        assert (responseReader != null);
        this.streamFactory = streamFactory;
        this.callback = callback;
        this.methodName = methodName;
        this.statsContext = statsContext;
        this.responseReader = responseReader;
        this.tokenExceptionHandler = tokenExceptionHandler;
    }

    @Override
    public void onError(Request request, Throwable exception) {
        this.callback.onFailure(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void onResponseReceived(Request request, Response response) {
        Throwable returned;
        boolean e322222222;
        Object result = null;
        Throwable caught = null;
        try {
            boolean toss;
            String encodedResponse2333333332 = response.getText();
            int statusCode = response.getStatusCode();
            boolean bl = toss = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.bytesStat(this.methodName, encodedResponse2333333332.length(), "responseReceived"));
            if (statusCode != 200) {
                caught = new StatusCodeException(statusCode, response.getStatusText(), encodedResponse2333333332);
            } else if (encodedResponse2333333332 == null) {
                caught = new InvocationException("No response payload from " + this.methodName);
            } else if (RemoteServiceProxy.isReturnValue(encodedResponse2333333332)) {
                result = this.responseReader.read(this.streamFactory.createStreamReader(encodedResponse2333333332));
            } else {
                caught = RemoteServiceProxy.isThrownException(encodedResponse2333333332) ? (Throwable)this.streamFactory.createStreamReader(encodedResponse2333333332).readObject() : new InvocationException(encodedResponse2333333332 + " from " + this.methodName);
            }
            boolean encodedResponse2333333332 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
        }
        catch (SerializationException e222222222) {
            caught = new IncompatibleRemoteServiceException("The response could not be deserialized", e222222222);
            e322222222 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
        }
        catch (Throwable e322222222) {
            caught = e322222222;
            e322222222 = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
            {
                catch (Throwable throwable) {
                    boolean bl = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, "responseDeserialized"));
                    throw throwable;
                }
            }
        }
        try {
            if (caught == null) {
                this.callback.onSuccess((Throwable)result);
            } else if (this.tokenExceptionHandler != null && caught instanceof RpcTokenException) {
                this.tokenExceptionHandler.onRpcTokenException((RpcTokenException)caught);
            } else {
                this.callback.onFailure(caught);
            }
            returned = caught == null ? result : caught;
        }
        catch (Throwable throwable) {
            Throwable returned2 = caught == null ? result : caught;
            boolean bl = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, returned2, "end"));
            throw throwable;
        }
        boolean bl = this.statsContext.isStatsAvailable() && this.statsContext.stats(this.statsContext.timeStat(this.methodName, returned, "end"));
    }

    public static enum ResponseReader {
        BOOLEAN{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readBoolean();
            }
        }
        ,
        BYTE{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readByte();
            }
        }
        ,
        CHAR{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Character.valueOf(streamReader.readChar());
            }
        }
        ,
        DOUBLE{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readDouble();
            }
        }
        ,
        FLOAT{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return Float.valueOf(streamReader.readFloat());
            }
        }
        ,
        INT{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readInt();
            }
        }
        ,
        LONG{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readLong();
            }
        }
        ,
        OBJECT{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readObject();
            }
        }
        ,
        SHORT{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readShort();
            }
        }
        ,
        STRING{

            @Override
            public Object read(SerializationStreamReader streamReader) throws SerializationException {
                return streamReader.readString();
            }
        }
        ,
        VOID{

            @Override
            public Object read(SerializationStreamReader streamReader) {
                return null;
            }
        };


        public abstract Object read(SerializationStreamReader var1) throws SerializationException;
    }
}

