/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater;

import com.allen_sauer.gwt.log.client.Log;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import org.nuxeo.ecm.platform.annotations.gwt.client.controler.AnnotationController;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationChangeListener;
import org.nuxeo.ecm.platform.annotations.gwt.client.model.AnnotationModel;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.Utils;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPathUtil;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.NewAnnotationPopup;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.annotater.AbstractAnnotater;
import org.nuxeo.ecm.platform.annotations.gwt.client.view.decorator.ImageDecorator;

public class ImageAnnotater
extends AbstractAnnotater
implements AnnotationChangeListener {
    private boolean writing = false;
    private boolean processing = false;
    private final ImageDecorator decorator;
    private DivElement divElement;
    private int ax = -1;
    private int ay = -1;
    private int bx = -1;
    private int by = -1;
    private ImageElement image;

    public ImageAnnotater(AnnotationController controller) {
        super(controller, true);
        this.decorator = new ImageDecorator(controller);
        controller.addModelChangeListener(this);
    }

    public void refresh() {
        this.ax = -1;
        this.ay = -1;
        this.bx = -1;
        this.by = -1;
    }

    @Override
    public void onMouseDown(Event event) {
        super.onMouseDown(event);
        if (this.writing) {
            Log.debug((String)"ImageAnnotater] Ignore mouse down event");
            return;
        }
        if (this.processing) {
            this.divElement.getParentElement().removeChild((Node)this.divElement);
        }
        this.image = this.getRootImage(event);
        int[] absoluteTopLeft = Utils.getAbsoluteTopLeft((com.google.gwt.dom.client.Element)this.image, Document.get());
        this.ax = event.getClientX() - absoluteTopLeft[1] + Window.getScrollLeft();
        this.ay = event.getClientY() - absoluteTopLeft[0] + Window.getScrollTop();
        this.bx = this.ax;
        this.by = this.ay;
        this.writing = true;
        this.processing = true;
        this.controller.disablePopupListeners();
        this.addMap(this.ax, this.ay, this.bx, this.by, this.image);
    }

    private ImageElement getRootImage(Event event) {
        com.google.gwt.dom.client.Element targetElement = event.getTarget();
        ImageElement imageElement = ImageElement.as((com.google.gwt.dom.client.Element)targetElement.getOwnerDocument().getElementById("annotationRootImage"));
        if (imageElement == null) {
            if (targetElement.getNodeName().equalsIgnoreCase("img")) {
                imageElement = ImageElement.as((com.google.gwt.dom.client.Element)targetElement);
            } else if (targetElement.getNodeName().equalsIgnoreCase("div")) {
                imageElement = ImageAnnotater.getImageElementFromAnchor(targetElement);
            }
        }
        return imageElement;
    }

    private static ImageElement getImageElementFromAnchor(com.google.gwt.dom.client.Element anchorElement) {
        Node element;
        while ((element = anchorElement.getPreviousSibling()) != null) {
            Log.debug((String)("getImageElementFromAnchor -- nodeName: " + element.getNodeName()));
            if (!element.getNodeName().equalsIgnoreCase("img")) continue;
            return ImageElement.as((com.google.gwt.dom.client.Element)((com.google.gwt.dom.client.Element)element.cast()));
        }
        return null;
    }

    @Override
    public void onMouseMove(Event event) {
        ImageElement newImage;
        super.onMouseMove(event);
        if (!this.writing) {
            return;
        }
        String nodeName = event.getTarget().getNodeName();
        if (!(!nodeName.equalsIgnoreCase("img") || this.image.equals((Object)(newImage = ImageElement.as((com.google.gwt.dom.client.Element)event.getTarget()))) && this.ax != -1 && this.ay != -1 || this.controller.isMultiImage())) {
            this.refresh();
        }
        int[] absoluteTopLeft = Utils.getAbsoluteTopLeft((com.google.gwt.dom.client.Element)this.image, Document.get());
        this.bx = event.getClientX() - absoluteTopLeft[1] + Window.getScrollLeft();
        this.by = event.getClientY() - absoluteTopLeft[0] + Window.getScrollTop();
        this.updateMap(this.ax, this.ay, this.bx, this.by, this.image);
    }

    @Override
    public void onMouseUp(Event event) {
        ImageElement newImage;
        if (!this.hasMoved() && this.writing) {
            Log.debug((String)"cancel mouse up image");
            this.cancelMap();
            this.controller.setNewAnnotationPopup(null);
            if (this.controller.isAnnotationsVisible()) {
                this.controller.enablePopupListeners();
            }
            super.onMouseUp(event);
            return;
        }
        super.onMouseUp(event);
        if (!this.writing) {
            return;
        }
        String nodeName = event.getTarget().getNodeName();
        if (!(!nodeName.equalsIgnoreCase("img") || this.image.equals((Object)(newImage = ImageElement.as((com.google.gwt.dom.client.Element)event.getTarget()))) && this.ax != -1 && this.ay != -1 || this.controller.isMultiImage())) {
            this.refresh();
        }
        int[] absoluteTopLeft = Utils.getAbsoluteTopLeft((com.google.gwt.dom.client.Element)this.image, Document.get());
        this.bx = event.getClientX() - absoluteTopLeft[1] + Window.getScrollLeft();
        this.by = event.getClientY() - absoluteTopLeft[0] + Window.getScrollTop();
        this.addMapAndGetAnnot(new int[]{this.ax, this.ay, this.bx, this.by}, this.image);
        if (this.controller.isAnnotationsVisible()) {
            this.controller.enablePopupListeners();
        }
        this.writing = false;
        this.addAnnotationPopup();
        this.controller.enablePopupListeners();
    }

    private void cancelMap() {
        this.writing = false;
        this.processing = false;
        if (this.divElement != null) {
            DOM.setEventListener((com.google.gwt.dom.client.Element)((Element)this.divElement.cast()), null);
            Log.debug((String)("Parent element: " + this.divElement.getParentElement()));
            if (this.divElement.getParentElement() != null) {
                this.divElement.getParentElement().removeChild((Node)this.divElement);
            }
        }
    }

    public void updateMap(int ax2, int ay2, int bx2, int by2, ImageElement img) {
        this.decorator.updateAnnotatedArea(ax2, ay2, bx2, by2, img, this.divElement);
    }

    private void addMap(int ax2, int ay2, int ax3, int ay3, ImageElement img) {
        this.divElement = this.decorator.addAnnotatedArea(this.ax, this.ay, this.bx, this.by, this);
    }

    public void addMapAndGetAnnot(int[] points, ImageElement img) {
        DOM.setEventListener((com.google.gwt.dom.client.Element)((Element)this.divElement.cast()), null);
        String xpath = img.getParentElement().getId();
        xpath = XPathUtil.fromIdableName(xpath);
        ImageAnnotater.checkInt(points);
        String xpointer = this.controller.filterXPointer(this.image, xpath, points[0], points[1], points[2], points[3]);
        Log.debug((String)("XPointer: " + xpointer));
        this.controller.createNewAnnotation(xpointer);
        NewAnnotationPopup popup = new NewAnnotationPopup((com.google.gwt.dom.client.Element)this.divElement, this.controller, true, "local");
        this.controller.setNewAnnotationPopup(popup);
    }

    private static void checkInt(int[] points) {
        for (int x = 0; x < points.length; ++x) {
            points[x] = ("" + points[x]).contains(".") ? Integer.parseInt(("" + points[x]).substring(0, ("" + points[x]).indexOf("."))) : points[x];
        }
    }

    public ImageElement getImage() {
        return this.image;
    }

    public void setImage(ImageElement image) {
        this.image = image;
    }

    public void updateMap(int bx2, int by2, ImageElement image2) {
        this.decorator.updateAnnotatedArea(this.ax, this.ay, bx2, by2, image2, this.divElement);
    }

    @Override
    public void onChange(AnnotationModel model, AnnotationChangeListener.ChangeEvent ce) {
        if (model.getNewAnnotation() == null && ce == AnnotationChangeListener.ChangeEvent.annotation) {
            this.processing = false;
        }
    }
}

