/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository.service;

import java.security.Principal;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotatedDocumentEventListener;
import org.nuxeo.runtime.api.Framework;

public class AnnotatedDocumentEventListenerImpl
implements AnnotatedDocumentEventListener {
    private static final Log log = LogFactory.getLog(AnnotatedDocumentEventListenerImpl.class);

    @Override
    public void beforeAnnotationCreated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void beforeAnnotationDeleted(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void beforeAnnotationRead(NuxeoPrincipal principal, String annotationId) {
    }

    @Override
    public void beforeAnnotationUpdated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void afterAnnotationCreated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent("annotationCreated", annotation, documentLoc, principal);
    }

    @Override
    public void afterAnnotationDeleted(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent("annotationDeleted", annotation, documentLoc, principal);
    }

    @Override
    public void afterAnnotationRead(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
    }

    @Override
    public void afterAnnotationUpdated(NuxeoPrincipal principal, DocumentLocation documentLoc, Annotation annotation) {
        this.notifyEvent("annotationUpdated", annotation, documentLoc, principal);
    }

    protected void notifyEvent(String eventId, Annotation annotation, DocumentLocation documentLocation, NuxeoPrincipal principal) {
        if (documentLocation == null) {
            return;
        }
        try (CloseableCoreSession session = CoreInstance.openCoreSessionSystem((String)documentLocation.getServerName());){
            DocumentModel doc = null;
            if (session.exists(documentLocation.getDocRef())) {
                doc = session.getDocument(documentLocation.getDocRef());
            }
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("annotationId", annotation.getId());
            properties.put("annotationSubject", (String)annotation.getSubject());
            properties.put("annotationBody", annotation.getBodyAsText());
            EventContextImpl ctx = null;
            if (doc != null) {
                DocumentEventContext docCtx = new DocumentEventContext((CoreSession)session, (Principal)principal, doc);
                docCtx.setCategory("eventDocumentCategory");
                ctx = docCtx;
            } else {
                ctx = new EventContextImpl((CoreSession)session, (Principal)principal);
            }
            ctx.setRepositoryName(documentLocation.getServerName());
            ctx.setProperties(properties);
            Event event = ctx.newEvent(eventId);
            ((EventProducer)Framework.getService(EventProducer.class)).fireEvent(event);
            session.save();
        }
    }
}

