/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools.operations;

import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.BlobCollector;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.video.tools.VideoToolsService;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Video.Slice", category="Conversion", label="SliceVideo the video for a given duration and startAt time.", description="SliceVideo the input blob starting at startAt, for a certain duration. The duration and startAt arguments are optional, but not simultaneously. A specific converter can be used.")
public class SliceVideo {
    public static final String ID = "Video.Slice";
    @Param(name="startAt", required=false)
    protected String startAt;
    @Param(name="duration", required=false)
    protected String duration;
    @Param(name="encode", required=false, values={"true"})
    protected boolean encode = true;
    @Param(name="xpath", required=false)
    protected String xpath;

    @OperationMethod
    public Blob run(DocumentModel input) throws OperationException {
        if (StringUtils.isEmpty((String)this.xpath)) {
            return this.run(((BlobHolder)input.getAdapter(BlobHolder.class)).getBlob());
        }
        return this.run((Blob)input.getPropertyValue(this.xpath));
    }

    @OperationMethod
    public BlobList run(DocumentModelList input) throws OperationException {
        BlobList blobList = new BlobList();
        for (DocumentModel doc : input) {
            blobList.add((Object)this.run(doc));
        }
        return blobList;
    }

    @OperationMethod(collector=BlobCollector.class)
    public Blob run(Blob input) throws OperationException {
        try {
            VideoToolsService videoService = (VideoToolsService)Framework.getService(VideoToolsService.class);
            return (Blob)videoService.slice(input, StringUtils.isEmpty((String)this.startAt) ? "00:00" : this.startAt, this.duration, this.encode).get(0);
        }
        catch (NuxeoException e) {
            throw new OperationException((Throwable)e);
        }
    }
}

