/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.annotations.http.AnnotationServiceFacade;

public class AnnotationsServlet
extends HttpServlet {
    private static final String REPLACE_SOURCE = "replace_source";
    private static final String W3C_ANNOTATES = "w3c_annotates";
    private static final String DOCUMENT_URL = "document_url";
    private static final long serialVersionUID = 1L;
    private AnnotationServiceFacade facade;

    public void init() {
        this.facade = new AnnotationServiceFacade();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String w3c_annotates = req.getParameter(W3C_ANNOTATES);
        String annId = null;
        if (req.getPathInfo() != null) {
            annId = req.getPathInfo().replaceFirst("/", "");
        }
        resp.setContentType("application/xml");
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        if (annId != null) {
            this.facade.getAnnotation(annId, (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), req.getRequestURL() + "/");
        } else if (w3c_annotates != null && !w3c_annotates.isEmpty()) {
            this.facade.query(w3c_annotates, (OutputStream)resp.getOutputStream(), (NuxeoPrincipal)req.getUserPrincipal());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        String replace_source = req.getParameter(REPLACE_SOURCE);
        if (replace_source != null) {
            ServletInputStream is = req.getInputStream();
            this.facade.updateAnnotation((InputStream)is, (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), AnnotationsServlet.getBaseUrl(req));
        } else {
            StringBuffer baseUrl = req.getRequestURL();
            this.facade.createAnnotation((InputStream)req.getInputStream(), (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), baseUrl.toString());
        }
    }

    private static String getBaseUrl(HttpServletRequest req) {
        StringBuffer url = req.getRequestURL();
        int index = url.indexOf(req.getServletPath());
        return url.substring(0, index);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        String annId = req.getPathInfo().replaceFirst("/", "");
        String documentUrl = req.getParameter(DOCUMENT_URL);
        this.facade.deleteFor(documentUrl, annId, (NuxeoPrincipal)req.getUserPrincipal(), AnnotationsServlet.getBaseUrl(req) + "/");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setHeader("Cache-Control", "no-cache");
        resp.setHeader("Pragma", "no-cache");
        this.facade.updateAnnotation((InputStream)req.getInputStream(), (NuxeoPrincipal)req.getUserPrincipal(), (OutputStream)resp.getOutputStream(), req.getRequestURL() + "/");
    }
}

