/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.tools;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;

public abstract class VideoTool {
    protected String name;
    protected String commandLineName;
    protected static final String SOURCE_FILE_PATH_PARAM = "sourceFilePath";
    protected static final String OUTPUT_FILE_PATH_PARAM = "outFilePath";
    protected static final String OUTPUT_MIMETYPE_PARAM = "outputMimetype";
    protected static final String VIDEO_TOOLS_DIRECTORY = "NuxeoVideoTools";

    public VideoTool(String name, String commandLineName) {
        this.name = name;
        this.commandLineName = commandLineName;
    }

    public String getName() {
        return this.name;
    }

    public String getCommandLineName() {
        return this.commandLineName;
    }

    public Map<String, String> setupParameters(BlobHolder input, Map<String, Object> parameters) {
        HashMap<String, String> cmdParameters = new HashMap<String, String>();
        cmdParameters.put(SOURCE_FILE_PATH_PARAM, input.getBlob().getFile().getAbsolutePath());
        return cmdParameters;
    }

    public void cleanupInputs(Map<String, String> parameters) {
    }

    public BlobHolder buildResult(String mimeType, Map<String, String> parameters) {
        String path = parameters.get(OUTPUT_FILE_PATH_PARAM);
        mimeType = parameters.getOrDefault(OUTPUT_MIMETYPE_PARAM, mimeType);
        Blob blob = VideoTool.getTemporaryBlob(path, mimeType);
        return new SimpleBlobHolder(blob);
    }

    public static Blob getTemporaryBlob(String path, String mimeType) {
        FileBlob blob;
        String ext = "." + FilenameUtils.getExtension((String)path);
        try {
            blob = new FileBlob(ext);
            Files.move(Paths.get(path, new String[0]), blob.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        blob.setMimeType(mimeType);
        blob.setFilename(FilenameUtils.getName((String)path));
        return blob;
    }
}

