/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class PictureConversionRegistry
extends ContributionFragmentRegistry<PictureConversion> {
    private static final Log log = LogFactory.getLog(PictureConversionRegistry.class);
    protected final Map<String, PictureConversion> pictureConversions = new HashMap<String, PictureConversion>();

    public PictureConversion getPictureConversion(String id) {
        return this.pictureConversions.get(id);
    }

    public List<PictureConversion> getPictureConversions() {
        ArrayList<PictureConversion> entries = new ArrayList<PictureConversion>(this.pictureConversions.values());
        Collections.sort(entries);
        return entries;
    }

    public String getContributionId(PictureConversion pictureConversion) {
        return pictureConversion.getId();
    }

    public void contributionUpdated(String id, PictureConversion pictureConversion, PictureConversion oldPictureConversion) {
        if (this.pictureConversions.containsKey(id)) {
            this.contributionRemoved(id, pictureConversion);
        }
        if (pictureConversion.isEnabled()) {
            if (!StringUtils.isBlank((String)id)) {
                this.pictureConversions.put(id, pictureConversion);
            } else {
                log.warn((Object)String.format("Missing 'id' for picture conversion %s, not registering it.", pictureConversion));
            }
        }
    }

    public void contributionRemoved(String id, PictureConversion pictureConversion) {
        this.pictureConversions.remove(id);
    }

    public PictureConversion clone(PictureConversion pictureConversion) {
        return pictureConversion.clone();
    }

    public void merge(PictureConversion source, PictureConversion dest) {
        dest.merge(source);
    }
}

