/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.annotations.api.UriResolver;

public class DefaultUriResolver
implements UriResolver {
    private static final String NUXEO_ANNOTATIONS = "nuxeo/Annotations/";

    public String getBaseUrl(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            String url = uri.toURL().toString();
            if (url.contains(NUXEO_ANNOTATIONS)) {
                return url.substring(0, url.indexOf(NUXEO_ANNOTATIONS) + NUXEO_ANNOTATIONS.length());
            }
            return url.substring(0, url.indexOf("nuxeo") + "nuxeo".length());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public URI getSearchURI(URI uri) {
        return uri;
    }

    public URI translateFromGraphURI(URI uri, String baseUrl) {
        if (uri.toString().startsWith("urn:annotation:")) {
            String annId = uri.toString().substring(uri.toString().lastIndexOf(":") + 1);
            try {
                return new URI(baseUrl + annId);
            }
            catch (URISyntaxException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return uri;
    }

    public URI translateToGraphURI(URI uri) {
        String path = uri.getPath();
        if (uri.toString().contains(NUXEO_ANNOTATIONS)) {
            try {
                return new URI("urn:annotation:" + path.substring(path.lastIndexOf("/") + 1));
            }
            catch (URISyntaxException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return uri;
    }
}

