/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.autobean.vm.impl;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.vm.impl.BeanMethod;
import com.google.web.bindery.autobean.vm.impl.ProxyAutoBean;
import com.google.web.bindery.autobean.vm.impl.TypeUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class ShimHandler<T>
implements InvocationHandler {
    private final ProxyAutoBean<T> bean;
    private final Method interceptor;

    public ShimHandler(ProxyAutoBean<T> bean, T toWrap) {
        this.bean = bean;
        Method maybe = null;
        for (Class<?> clazz : bean.getConfiguration().getCategories()) {
            try {
                maybe = clazz.getMethod("__intercept", AutoBean.class, Object.class);
                break;
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        this.interceptor = maybe;
    }

    public boolean equals(Object couldBeShim) {
        if (couldBeShim == null) {
            return false;
        }
        if (Proxy.isProxyClass(couldBeShim.getClass()) && this == Proxy.getInvocationHandler(couldBeShim)) {
            return true;
        }
        return this.bean.getWrapped().equals(couldBeShim);
    }

    public int hashCode() {
        return this.bean.getWrapped().hashCode();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object toReturn;
        method.setAccessible(true);
        String name = method.getName();
        method.setAccessible(true);
        try {
            if (BeanMethod.OBJECT.matches(method)) {
                return method.invoke((Object)this, args);
            }
            if (BeanMethod.GET.matches(method)) {
                toReturn = method.invoke(this.bean.getWrapped(), args);
                toReturn = this.bean.get(name, toReturn);
            } else if (BeanMethod.SET.matches(method) || BeanMethod.SET_BUILDER.matches(method)) {
                toReturn = method.invoke(this.bean.getWrapped(), args);
                this.bean.set(name, args[0]);
            } else {
                toReturn = method.invoke(this.bean.getWrapped(), args);
                this.bean.call(name, toReturn, args);
            }
            Class<?> intf = method.getReturnType();
            if (!Object.class.equals(intf)) {
                toReturn = this.maybeWrap(intf, toReturn);
            }
            if (this.interceptor != null) {
                toReturn = this.interceptor.invoke(null, this.bean, toReturn);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return toReturn;
    }

    public String toString() {
        return this.bean.getWrapped().toString();
    }

    private Object maybeWrap(Class<?> intf, Object toReturn) {
        if (toReturn == null) {
            return null;
        }
        AutoBean returnBean = AutoBeanUtils.getAutoBean(toReturn);
        if (returnBean != null) {
            return returnBean.as();
        }
        if (TypeUtils.isValueType(intf) || TypeUtils.isValueType(toReturn.getClass()) || this.bean.getConfiguration().getNoWrap().contains(intf)) {
            return toReturn;
        }
        if (toReturn.getClass().isArray()) {
            return toReturn;
        }
        ProxyAutoBean<Object> newBean = new ProxyAutoBean<Object>(this.bean.getFactory(), intf, this.bean.getConfiguration(), toReturn);
        return newBean.as();
    }
}

