/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.helpers.StringMaker;
import org.nuxeo.runtime.api.Framework;

public class PictureTilesImpl
implements PictureTiles,
Serializable {
    private static final long serialVersionUID = 1L;
    public static String TILE_OUTPUT_DIR_KEY = "outputDirPath";
    public static String TILE_INPUT_FILE_KEY = "inputFilePath";
    public static String X_TILES_KEY = "XTiles";
    public static String Y_TILES_KEY = "YTiles";
    public static String LAST_MODIFICATION_DATE_KEY = "lastModificationDate";
    public static String TILES_PREFIX_KEY = "TilesPrefix";
    public static String TILES_SUFFIX_KEY = "TilesSuffix";
    public static String TILES_WIDTH_KEY = "TilesWidth";
    public static String TILES_HEIGHT_KEY = "TilesHeight";
    public static String MAX_TILES_KEY = "MaxTiles";
    public static String PROGRESSIVE_TILING_KEY = "ProgressiveTiling";
    protected Map<String, String> infoMap;
    protected String tilesDirPath;
    protected String cacheKey;
    protected ImageInfo sourceImageInfo;
    protected ImageInfo originalImageInfo;

    public PictureTilesImpl(String tilesDirPath) {
        this.tilesDirPath = tilesDirPath;
    }

    public PictureTilesImpl(Map<String, String> info) {
        this.infoMap = info;
        this.tilesDirPath = info.get(TILE_OUTPUT_DIR_KEY);
    }

    @Override
    public String getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    @Override
    public Map<String, String> getInfo() {
        return this.infoMap;
    }

    @Override
    public boolean isTileComputed(int x, int y) {
        long lastModificationTime = Long.parseLong(this.infoMap.get(LAST_MODIFICATION_DATE_KEY));
        String tileFileName = StringMaker.getTileFileName(x, y, this.infoMap.get(TILES_PREFIX_KEY), this.infoMap.get(TILES_SUFFIX_KEY), lastModificationTime);
        File imageFile = new File(this.tilesDirPath + tileFileName);
        return imageFile.exists();
    }

    @Override
    public Blob getTile(int x, int y) throws IOException {
        String imageFilePath = this.getTileFilePath(x, y);
        File imageFile = new File(imageFilePath);
        if (imageFile.exists()) {
            return Blobs.createBlob((File)imageFile);
        }
        PictureTilingService pts = (PictureTilingService)Framework.getService(PictureTilingService.class);
        pts.completeTiles(this, x, y);
        imageFile = new File(imageFilePath);
        if (imageFile.exists()) {
            return Blobs.createBlob((File)imageFile);
        }
        throw new NuxeoException("Unable to get Tile");
    }

    public String getTileFilePath(int x, int y) {
        long lastModificationTime = Long.parseLong(this.infoMap.get(LAST_MODIFICATION_DATE_KEY));
        String tileFileName = StringMaker.getTileFileName(x, y, this.infoMap.get(TILES_PREFIX_KEY), this.infoMap.get(TILES_SUFFIX_KEY), lastModificationTime);
        String imageFilePath = new Path(this.tilesDirPath).append(tileFileName).toString();
        return imageFilePath;
    }

    @Override
    public int getMaxTiles() {
        String MT = this.infoMap.get(MAX_TILES_KEY);
        if (MT == null) {
            return 0;
        }
        return Integer.parseInt(MT);
    }

    @Override
    public int getTilesWidth() {
        String TW = this.infoMap.get(TILES_WIDTH_KEY);
        if (TW == null) {
            return 0;
        }
        return Integer.parseInt(TW);
    }

    @Override
    public int getTilesHeight() {
        String TH = this.infoMap.get(TILES_HEIGHT_KEY);
        if (TH == null) {
            return 0;
        }
        return Integer.parseInt(TH);
    }

    @Override
    public String getTilesPath() {
        return this.tilesDirPath;
    }

    @Override
    public int getXTiles() {
        String XT = this.infoMap.get(X_TILES_KEY);
        if (XT == null) {
            return 0;
        }
        return Integer.parseInt(XT);
    }

    @Override
    public int getYTiles() {
        String YT = this.infoMap.get(Y_TILES_KEY);
        if (YT == null) {
            return 0;
        }
        return Integer.parseInt(YT);
    }

    @Override
    public float getZoomfactor() {
        float oWith = this.originalImageInfo.getWidth();
        float tWith = this.getXTiles() * this.getTilesWidth();
        float oHeight = this.originalImageInfo.getHeight();
        float tHeight = this.getYTiles() * this.getTilesHeight();
        return tWith / oWith < tHeight / oHeight ? tWith / oWith : tHeight / oHeight;
    }

    @Override
    public void release() {
        long lastModificationTime = Long.parseLong(this.infoMap.get(LAST_MODIFICATION_DATE_KEY));
        for (int x = 0; x < this.getXTiles(); ++x) {
            for (int y = 0; y < this.getYTiles(); ++y) {
                String tileFileName = StringMaker.getTileFileName(x, y, this.infoMap.get(TILES_PREFIX_KEY), this.infoMap.get(TILES_SUFFIX_KEY), lastModificationTime);
                File img = new File(this.tilesDirPath + tileFileName);
                if (!img.exists()) continue;
                img.delete();
            }
        }
    }

    @Override
    public ImageInfo getSourceImageInfo() {
        return this.sourceImageInfo;
    }

    @Override
    public void setSourceImageInfo(ImageInfo imageInfo) {
        this.sourceImageInfo = imageInfo;
    }

    @Override
    public String getTileFormatCacheKey() {
        return StringMaker.getTileFormatString(this.getTilesWidth(), this.getTilesHeight(), this.getMaxTiles());
    }

    @Override
    public ImageInfo getOriginalImageInfo() {
        return this.originalImageInfo;
    }

    @Override
    public void setOriginalImageInfo(ImageInfo imageInfo) {
        this.originalImageInfo = imageInfo;
    }
}

