/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.server;

import com.google.gwt.typedarrays.server.ArrayBufferImpl;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;

public abstract class ArrayBufferViewImpl
implements ArrayBufferView {
    static final boolean USE_LITTLE_ENDIAN = true;
    protected final ArrayBufferImpl arrayBuf;
    protected final int byteLength;
    protected final int byteOffset;

    public ArrayBufferViewImpl(ArrayBuffer buffer, int byteOffset, int byteLength) {
        if (!(buffer instanceof ArrayBufferImpl)) {
            throw new UnsupportedOperationException("Unacceptable ArrayBuffer type");
        }
        this.arrayBuf = (ArrayBufferImpl)buffer;
        this.byteOffset = byteOffset;
        this.byteLength = byteLength;
    }

    @Override
    public ArrayBuffer buffer() {
        return this.arrayBuf;
    }

    @Override
    public int byteLength() {
        return this.byteLength;
    }

    @Override
    public int byteOffset() {
        return this.byteOffset;
    }

    protected int checkRange(int index, int bytesPerElement) {
        int byteIndex = index * bytesPerElement;
        if (byteIndex < this.byteOffset || byteIndex + bytesPerElement > this.byteLength) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return byteIndex;
    }
}

