/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audio.extension;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class AudioImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AudioImporter.class);
    public static final String AUDIO_TYPE = "Audio";

    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String fullname, TypeManager typeService) throws IOException {
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        String title = FileManagerUtils.fetchTitle((String)filename);
        DocumentModel docModel = FileManagerUtils.getExistingDocByTitle((CoreSession)documentManager, (String)path, (String)title);
        if (overwrite && docModel != null) {
            docModel.setProperty("file", "content", (Object)content);
            docModel.setProperty("dublincore", "title", (Object)title);
            docModel = this.overwriteAndIncrementversion(documentManager, docModel);
        } else {
            PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
            String docType = this.getDocType();
            if (docType == null) {
                docType = AUDIO_TYPE;
            }
            docModel = documentManager.createDocumentModel(docType);
            docModel.setProperty("dublincore", "title", (Object)title);
            docModel.setProperty("file", "content", (Object)content);
            docModel.setProperty("file", "filename", (Object)filename);
            Type type = typeService.getType(docType);
            if (type != null) {
                String iconPath = type.getIcon();
                docModel.setProperty("common", "icon", (Object)iconPath);
            }
            docModel.setPathInfo(path, pss.generatePathSegment(docModel));
            docModel = documentManager.createDocument(docModel);
        }
        return docModel;
    }
}

