/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.mp4.Mp4AtomTree;
import org.jaudiotagger.audio.mp4.Mp4NotMetaFieldKey;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4FreeBox;
import org.jaudiotagger.audio.mp4.atom.Mp4HdlrBox;
import org.jaudiotagger.audio.mp4.atom.Mp4MetaBox;
import org.jaudiotagger.audio.mp4.atom.Mp4StcoBox;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.mp4.Mp4Tag;
import org.jaudiotagger.tag.mp4.Mp4TagCreator;

public class Mp4TagWriter {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    private Mp4TagCreator tc = new Mp4TagCreator();

    private void writeMetadataSameSize(ByteBuffer rawIlstData, long oldIlstSize, long startIstWithinFile, FileChannel fileReadChannel, FileChannel fileWriteChannel) throws CannotWriteException, IOException {
        fileReadChannel.position(0L);
        fileWriteChannel.transferFrom(fileReadChannel, 0L, startIstWithinFile);
        fileWriteChannel.position(startIstWithinFile);
        fileWriteChannel.write(rawIlstData);
        fileReadChannel.position(startIstWithinFile + oldIlstSize);
        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
    }

    private void adjustSizeOfMoovHeader(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
        if (udtaHeader != null) {
            udtaHeader.setLength(udtaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(udtaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(udtaHeader.getHeaderData());
        }
        if (metaHeader != null) {
            metaHeader.setLength(metaHeader.getLength() + sizeAdjustment);
            moovBuffer.position((int)(metaHeader.getFilePos() - moovHeader.getFilePos() - 8L));
            moovBuffer.put(metaHeader.getHeaderData());
        }
    }

    private void createMetadataAtoms(Mp4BoxHeader moovHeader, ByteBuffer moovBuffer, int sizeAdjustment, Mp4BoxHeader udtaHeader, Mp4BoxHeader metaHeader) throws IOException {
        moovHeader.setLength(moovHeader.getLength() + sizeAdjustment);
    }

    public void write(Tag tag, RandomAccessFile raf, RandomAccessFile rafTemp) throws CannotWriteException, IOException {
        DefaultMutableTreeNode parentNode;
        int relativeIlstEndPosition;
        int relativeIlstposition;
        int startIlstWithinFile;
        Mp4AtomTree atomTree;
        logger.info("Started writing tag data");
        ByteBuffer rawIlstData = this.tc.convert(tag);
        rawIlstData.rewind();
        FileChannel fileReadChannel = raf.getChannel();
        FileChannel fileWriteChannel = rafTemp.getChannel();
        int oldIlstSize = 0;
        int level1SearchPosition = 0;
        try {
            atomTree = new Mp4AtomTree(raf, false);
        }
        catch (CannotReadException cre) {
            throw new CannotWriteException(cre.getMessage());
        }
        Mp4BoxHeader moovHeader = atomTree.getBoxHeader(atomTree.getMoovNode());
        long positionWithinFileAfterFindingMoovHeader = moovHeader.getFilePos() + 8L;
        Mp4StcoBox stco = atomTree.getStco();
        Mp4BoxHeader ilstHeader = atomTree.getBoxHeader(atomTree.getIlstNode());
        Mp4BoxHeader udtaHeader = atomTree.getBoxHeader(atomTree.getUdtaNode());
        Mp4BoxHeader metaHeader = atomTree.getBoxHeader(atomTree.getMetaNode());
        Mp4BoxHeader hdlrMetaHeader = atomTree.getBoxHeader(atomTree.getHdlrWithinMetaNode());
        Mp4BoxHeader hdlrMdiaHeader = atomTree.getBoxHeader(atomTree.getHdlrWithinMdiaNode());
        Mp4BoxHeader mdatHeader = atomTree.getBoxHeader(atomTree.getMdatNode());
        if (mdatHeader == null) {
            throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_CANNOT_FIND_AUDIO.getMsg());
        }
        Mp4BoxHeader trakHeader = (Mp4BoxHeader)atomTree.getTrakNodes().get(0).getUserObject();
        ByteBuffer moovBuffer = atomTree.getMoovBuffer();
        if (udtaHeader != null) {
            if (metaHeader != null) {
                if (ilstHeader != null) {
                    oldIlstSize = ilstHeader.getLength();
                    startIlstWithinFile = (int)ilstHeader.getFilePos();
                    relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
                    relativeIlstEndPosition = relativeIlstposition + ilstHeader.getLength();
                } else if (hdlrMetaHeader != null) {
                    startIlstWithinFile = (int)hdlrMetaHeader.getFilePos() + hdlrMetaHeader.getLength();
                    relativeIlstEndPosition = relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
                } else {
                    startIlstWithinFile = (int)metaHeader.getFilePos() + 8 + 4;
                    relativeIlstEndPosition = relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
                }
            } else {
                relativeIlstEndPosition = relativeIlstposition = moovHeader.getLength() - 8;
                startIlstWithinFile = (int)(moovHeader.getFilePos() + (long)moovHeader.getLength());
            }
        } else if (metaHeader != null) {
            startIlstWithinFile = (int)trakHeader.getFilePos() + trakHeader.getLength();
            relativeIlstposition = (int)((long)startIlstWithinFile - (moovHeader.getFilePos() + 8L));
            relativeIlstEndPosition = relativeIlstposition + ilstHeader.getLength();
        } else {
            relativeIlstEndPosition = relativeIlstposition = moovHeader.getLength() - 8;
            startIlstWithinFile = (int)(moovHeader.getFilePos() + (long)moovHeader.getLength());
        }
        int newIlstSize = rawIlstData.limit();
        int oldMetaLevelFreeAtomSize = 0;
        long extraDataSize = 0L;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            DefaultMutableTreeNode brotherNode = freeNode.getPreviousSibling();
            if (parentNode.isRoot()) continue;
            Mp4BoxHeader header = (Mp4BoxHeader)parentNode.getUserObject();
            Mp4BoxHeader freeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            if (brotherNode == null) continue;
            Mp4BoxHeader brotherHeader = (Mp4BoxHeader)brotherNode.getUserObject();
            if (!header.getId().equals(Mp4NotMetaFieldKey.META.getFieldName()) || !brotherHeader.getId().equals(Mp4NotMetaFieldKey.ILST.getFieldName())) continue;
            oldMetaLevelFreeAtomSize = freeHeader.getLength();
            extraDataSize = moovHeader.getFilePos() + (long)moovHeader.getLength() - (freeHeader.getFilePos() + (long)freeHeader.getLength());
            break;
        }
        if (oldMetaLevelFreeAtomSize == 0) {
            extraDataSize = moovHeader.getDataLength() - relativeIlstEndPosition;
        }
        level1SearchPosition = 0;
        int topLevelFreePosition = 0;
        int topLevelFreeSize = 0;
        boolean topLevelFreeAtomComesBeforeMdatAtom = true;
        for (DefaultMutableTreeNode freeNode : atomTree.getFreeNodes()) {
            parentNode = (DefaultMutableTreeNode)freeNode.getParent();
            if (!parentNode.isRoot()) continue;
            Mp4BoxHeader topLevelFreeHeader = (Mp4BoxHeader)freeNode.getUserObject();
            topLevelFreeSize = topLevelFreeHeader.getLength();
            level1SearchPosition = topLevelFreePosition = (int)topLevelFreeHeader.getFilePos();
            break;
        }
        if (topLevelFreeSize > 0) {
            if ((long)topLevelFreePosition > mdatHeader.getFilePos()) {
                topLevelFreeAtomComesBeforeMdatAtom = false;
                level1SearchPosition = (int)mdatHeader.getFilePos();
            }
        } else {
            level1SearchPosition = topLevelFreePosition = (int)mdatHeader.getFilePos();
        }
        logger.info("Read header successfully ready for writing");
        if (oldIlstSize == newIlstSize) {
            logger.info("Writing:Option 1:Same Size");
            this.writeMetadataSameSize(rawIlstData, oldIlstSize, startIlstWithinFile, fileReadChannel, fileWriteChannel);
        } else if (oldIlstSize > newIlstSize) {
            Mp4FreeBox newFreeBox;
            if (oldMetaLevelFreeAtomSize > 0) {
                logger.info("Writing:Option 2:Smaller Size have free atom:" + oldIlstSize + ":" + newIlstSize);
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, startIlstWithinFile);
                fileWriteChannel.position(startIlstWithinFile);
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                int newFreeSize = oldMetaLevelFreeAtomSize + (oldIlstSize - newIlstSize);
                newFreeBox = new Mp4FreeBox(newFreeSize - 8);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
            } else {
                int newFreeSize = oldIlstSize - newIlstSize - 8;
                if (newFreeSize > 0) {
                    logger.info("Writing:Option 3:Smaller Size can create free atom");
                    fileReadChannel.position(0L);
                    fileWriteChannel.transferFrom(fileReadChannel, 0L, startIlstWithinFile);
                    fileWriteChannel.position(startIlstWithinFile);
                    fileWriteChannel.write(rawIlstData);
                    fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                    newFreeBox = new Mp4FreeBox(newFreeSize);
                    fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                    fileWriteChannel.write(newFreeBox.getData());
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                } else {
                    logger.info("Writing:Option 4:Smaller Size <=8 cannot create free atoms");
                    int sizeReducedBy = oldIlstSize - newIlstSize;
                    fileReadChannel.position(0L);
                    fileWriteChannel.transferFrom(fileReadChannel, 0L, moovHeader.getFilePos());
                    fileWriteChannel.position(moovHeader.getFilePos());
                    if (mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        stco.adjustOffsets(-sizeReducedBy);
                    }
                    this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, -sizeReducedBy, udtaHeader, metaHeader);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                    fileWriteChannel.write(rawIlstData);
                    fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                    if (extraDataSize > 0L) {
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraDataSize);
                        fileWriteChannel.position(fileWriteChannel.position() + extraDataSize);
                    }
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                }
            }
        } else {
            int additionalSpaceRequiredForMetadata = newIlstSize - oldIlstSize;
            if (additionalSpaceRequiredForMetadata <= oldMetaLevelFreeAtomSize - 8) {
                int newFreeSize = oldMetaLevelFreeAtomSize - additionalSpaceRequiredForMetadata;
                logger.info("Writing:Option 5;Larger Size can use meta free atom need extra:" + newFreeSize + "bytes");
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, startIlstWithinFile);
                fileWriteChannel.position(startIlstWithinFile);
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                Mp4FreeBox newFreeBox = new Mp4FreeBox(newFreeSize - 8);
                fileWriteChannel.write(newFreeBox.getHeader().getHeaderData());
                fileWriteChannel.write(newFreeBox.getData());
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
            } else {
                int additionalMetaSizeThatWontFitWithinMetaAtom = additionalSpaceRequiredForMetadata - oldMetaLevelFreeAtomSize;
                fileReadChannel.position(0L);
                fileWriteChannel.transferFrom(fileReadChannel, 0L, positionWithinFileAfterFindingMoovHeader - 8L);
                fileWriteChannel.position(positionWithinFileAfterFindingMoovHeader - 8L);
                if (udtaHeader == null) {
                    logger.info("Writing:Option 5.1;No udta atom");
                    Mp4HdlrBox hdlrBox = Mp4HdlrBox.createiTunesStyleHdlrBox();
                    Mp4MetaBox metaBox = Mp4MetaBox.createiTunesStyleMetaBox(hdlrBox.getHeader().getLength() + rawIlstData.limit());
                    udtaHeader = new Mp4BoxHeader(Mp4NotMetaFieldKey.UDTA.getFieldName());
                    udtaHeader.setLength(8 + metaBox.getHeader().getLength());
                    if ((!topLevelFreeAtomComesBeforeMdatAtom || topLevelFreeSize - 8 < (additionalMetaSizeThatWontFitWithinMetaAtom += udtaHeader.getLength() - rawIlstData.limit()) && topLevelFreeSize != additionalMetaSizeThatWontFitWithinMetaAtom) && mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        stco.adjustOffsets(additionalMetaSizeThatWontFitWithinMetaAtom);
                    }
                    moovHeader.setLength(moovHeader.getLength() + additionalMetaSizeThatWontFitWithinMetaAtom);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                    fileWriteChannel.write(udtaHeader.getHeaderData());
                    fileWriteChannel.write(metaBox.getHeader().getHeaderData());
                    fileWriteChannel.write(metaBox.getData());
                    fileWriteChannel.write(hdlrBox.getHeader().getHeaderData());
                    fileWriteChannel.write(hdlrBox.getData());
                } else {
                    logger.info("Writing:Option 5.2;udta atom exists");
                    if ((!topLevelFreeAtomComesBeforeMdatAtom || topLevelFreeSize - 8 < additionalMetaSizeThatWontFitWithinMetaAtom && topLevelFreeSize != additionalMetaSizeThatWontFitWithinMetaAtom) && mdatHeader.getFilePos() > moovHeader.getFilePos()) {
                        stco.adjustOffsets(additionalMetaSizeThatWontFitWithinMetaAtom);
                    }
                    this.adjustSizeOfMoovHeader(moovHeader, moovBuffer, additionalMetaSizeThatWontFitWithinMetaAtom, udtaHeader, metaHeader);
                    fileWriteChannel.write(moovHeader.getHeaderData());
                    moovBuffer.rewind();
                    moovBuffer.limit(relativeIlstposition);
                    fileWriteChannel.write(moovBuffer);
                }
                fileWriteChannel.write(rawIlstData);
                fileReadChannel.position(startIlstWithinFile + oldIlstSize);
                fileReadChannel.position(fileReadChannel.position() + (long)oldMetaLevelFreeAtomSize);
                if (extraDataSize > 0L) {
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), extraDataSize);
                    fileWriteChannel.position(fileWriteChannel.position() + extraDataSize);
                }
                if (topLevelFreeAtomComesBeforeMdatAtom && topLevelFreePosition > startIlstWithinFile) {
                    if (topLevelFreeSize - 8 >= additionalMetaSizeThatWontFitWithinMetaAtom) {
                        logger.info("Writing:Option 6;Larger Size can use top free atom");
                        Mp4FreeBox freeBox = new Mp4FreeBox(topLevelFreeSize - 8 - additionalMetaSizeThatWontFitWithinMetaAtom);
                        fileWriteChannel.write(freeBox.getHeader().getHeaderData());
                        fileWriteChannel.write(freeBox.getData());
                        fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                    } else if (topLevelFreeSize == additionalMetaSizeThatWontFitWithinMetaAtom) {
                        logger.info("Writing:Option 7;Larger Size uses top free atom including header");
                        fileReadChannel.position(fileReadChannel.position() + (long)topLevelFreeSize);
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                    } else {
                        logger.info("Writing:Option 8;Larger Size cannot use top free atom");
                        fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                    }
                } else {
                    logger.info("Writing:Option 9;Top Level Free comes after Mdat or before Metadata so cant use it");
                    fileWriteChannel.transferFrom(fileReadChannel, fileWriteChannel.position(), fileReadChannel.size() - fileReadChannel.position());
                }
            }
        }
        fileReadChannel.close();
        raf.close();
        this.checkFileWrittenCorrectly(rafTemp, mdatHeader, fileWriteChannel, stco);
    }

    private void checkFileWrittenCorrectly(RandomAccessFile rafTemp, Mp4BoxHeader mdatHeader, FileChannel fileWriteChannel, Mp4StcoBox stco) throws CannotWriteException, IOException {
        logger.info("Checking file has been written correctly");
        try {
            try {
                Mp4AtomTree newAtomTree = new Mp4AtomTree(rafTemp, false);
                Mp4BoxHeader newMdatHeader = newAtomTree.getBoxHeader(newAtomTree.getMdatNode());
                if (newMdatHeader == null) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_DATA.getMsg());
                }
                if (newMdatHeader.getLength() != mdatHeader.getLength()) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_DATA_CORRUPT.getMsg());
                }
                Mp4BoxHeader newUdtaHeader = newAtomTree.getBoxHeader(newAtomTree.getUdtaNode());
                if (newUdtaHeader == null) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
                }
                Mp4BoxHeader newMetaHeader = newAtomTree.getBoxHeader(newAtomTree.getMetaNode());
                if (newMetaHeader == null) {
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_NO_TAG_DATA.getMsg());
                }
                Mp4StcoBox newStco = newAtomTree.getStco();
                logger.finer("stco:Original First Offset" + stco.getFirstOffSet());
                logger.finer("stco:Original Diff" + (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos()));
                logger.finer("stco:Original Mdat Pos" + mdatHeader.getFilePos());
                logger.finer("stco:New First Offset" + newStco.getFirstOffSet());
                logger.finer("stco:New Diff" + (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos()));
                logger.finer("stco:New Mdat Pos" + newMdatHeader.getFilePos());
                int diff = (int)((long)stco.getFirstOffSet() - mdatHeader.getFilePos());
                if ((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() != (long)diff) {
                    int discrepancy = (int)((long)newStco.getFirstOffSet() - newMdatHeader.getFilePos() - (long)diff);
                    throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED_INCORRECT_OFFSETS.getMsg(discrepancy));
                }
                Object var13_13 = null;
            }
            catch (Exception e) {
                if (e instanceof CannotWriteException) {
                    throw (CannotWriteException)e;
                }
                e.printStackTrace();
                throw new CannotWriteException(ErrorMessage.MP4_CHANGES_TO_FILE_FAILED.getMsg() + ":" + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            rafTemp.close();
            fileWriteChannel.close();
            throw throwable;
        }
        rafTemp.close();
        fileWriteChannel.close();
        logger.info("File has been written correctly");
    }

    public void delete(RandomAccessFile raf, RandomAccessFile rafTemp) throws IOException {
        Mp4Tag tag = new Mp4Tag();
        try {
            this.write(tag, raf, rafTemp);
        }
        catch (CannotWriteException cwe) {
            throw new IOException(cwe.getMessage());
        }
    }
}

