/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.convert.ConverterUtils;
import org.nuxeo.runtime.api.Framework;

public class ResizePictureConverter
implements Converter {
    private static final Log log = LogFactory.getLog(ResizePictureConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        ImagingService service = (ImagingService)Framework.getService(ImagingService.class);
        List sources = blobHolder.getBlobs();
        ArrayList<Blob> results = new ArrayList<Blob>(sources.size());
        Serializable h = parameters.get("height");
        int height = ConverterUtils.getInteger(h);
        Serializable w = parameters.get("width");
        int width = ConverterUtils.getInteger(w);
        Serializable d = parameters.get("depth");
        int depth = ConverterUtils.getInteger(d);
        String format = (String)((Object)parameters.get("conversionFormat"));
        for (Blob source : sources) {
            Blob result;
            if (source == null || (result = service.resize(source, format, width, height, depth)) == null) continue;
            results.add(result);
        }
        return new SimpleCachableBlobHolder(results);
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

