/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.restlets;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTiles;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.restlets.PictureTilesCachedEntry;
import org.nuxeo.ecm.platform.pictures.tiles.serializer.JSONPictureTilesSerializer;
import org.nuxeo.ecm.platform.pictures.tiles.serializer.PictureTilesSerializer;
import org.nuxeo.ecm.platform.pictures.tiles.serializer.XMLPictureTilesSerializer;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.restlet.data.CharacterSet;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.OutputRepresentation;
import org.restlet.resource.Representation;

public class PictureTilesRestlets
extends BaseStatelessNuxeoRestlet {
    protected static int MAX_CACHE_LIFE = 600;
    protected static Map<String, PictureTilesCachedEntry> cachedAdapters = new ConcurrentHashMap<String, PictureTilesCachedEntry>();

    public void handle(Request req, Response res) {
        PictureTilesAdapter adapter;
        String repo = (String)req.getAttributes().get("repoId");
        String docid = (String)req.getAttributes().get("docId");
        Integer tileWidth = Integer.decode((String)req.getAttributes().get("tileWidth"));
        Integer tileHeight = Integer.decode((String)req.getAttributes().get("tileHeight"));
        Integer maxTiles = Integer.decode((String)req.getAttributes().get("maxTiles"));
        Form form = req.getResourceRef().getQueryAsForm();
        String xpath = form.getFirstValue("fieldPath");
        String x = form.getFirstValue("x");
        String y = form.getFirstValue("y");
        String format = form.getFirstValue("format");
        String test = form.getFirstValue("test");
        if (test != null) {
            try {
                this.handleSendTest(res, repo, docid, tileWidth, tileHeight, maxTiles);
                return;
            }
            catch (IOException e) {
                PictureTilesRestlets.handleError((Response)res, (Exception)e);
                return;
            }
        }
        if (repo == null || repo.equals("*")) {
            PictureTilesRestlets.handleError((Response)res, (String)"you must specify a repository");
            return;
        }
        if (docid == null || repo.equals("*")) {
            PictureTilesRestlets.handleError((Response)res, (String)"you must specify a documentId");
            return;
        }
        Boolean init = this.initRepositoryAndTargetDocument(res, repo, docid);
        if (!init.booleanValue()) {
            PictureTilesRestlets.handleError((Response)res, (String)"unable to init repository connection");
            return;
        }
        try {
            adapter = this.getFromCache(this.targetDocument, xpath);
            if (adapter == null) {
                adapter = (PictureTilesAdapter)this.targetDocument.getAdapter(PictureTilesAdapter.class);
                if (xpath != null && !"".equals(xpath)) {
                    adapter.setXPath(xpath);
                }
                this.updateCache(this.targetDocument, adapter, xpath);
            }
        }
        catch (NuxeoException e) {
            PictureTilesRestlets.handleError((Response)res, (Exception)((Object)e));
            return;
        }
        if (adapter == null) {
            this.handleNoTiles(res, null);
            return;
        }
        PictureTiles tiles = null;
        try {
            tiles = adapter.getTiles(tileWidth, tileHeight, maxTiles);
        }
        catch (NuxeoException e) {
            PictureTilesRestlets.handleError((Response)res, (Exception)((Object)e));
        }
        if (x == null || y == null) {
            this.handleSendInfo(res, tiles, format);
        } else {
            this.handleSendImage(res, tiles, Integer.decode(x), Integer.decode(y));
        }
    }

    protected void handleSendTest(Response res, String repoId, String docId, Integer tileWidth, Integer tileHeight, Integer maxTiles) throws IOException {
        MediaType mt = null;
        mt = MediaType.TEXT_HTML;
        File file = FileUtils.getResourceFileFromContext((String)"testTiling.html");
        String html = FileUtils.readFile((File)file);
        html = html.replace("$repoId$", repoId);
        html = html.replace("$docId$", docId);
        html = html.replace("$tileWidth$", tileWidth.toString());
        html = html.replace("$tileHeight$", tileHeight.toString());
        html = html.replace("$maxTiles$", maxTiles.toString());
        res.setEntity(html, mt);
    }

    protected void handleSendInfo(Response res, PictureTiles tiles, String format) {
        if (format == null) {
            format = "XML";
        }
        MediaType mt = null;
        PictureTilesSerializer serializer = null;
        if (format.equalsIgnoreCase("json")) {
            serializer = new JSONPictureTilesSerializer();
            mt = MediaType.APPLICATION_JSON;
        } else {
            serializer = new XMLPictureTilesSerializer();
            mt = MediaType.TEXT_XML;
        }
        res.setEntity(serializer.serialize(tiles), mt);
        res.getEntity().setCharacterSet(CharacterSet.UTF_8);
        HttpServletResponse response = PictureTilesRestlets.getHttpResponse((Response)res);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
    }

    protected void handleSendImage(Response res, PictureTiles tiles, Integer x, Integer y) {
        Blob image;
        try {
            image = tiles.getTile(x, y);
        }
        catch (IOException | NuxeoException e) {
            PictureTilesRestlets.handleError((Response)res, (Exception)e);
            return;
        }
        res.setEntity((Representation)new OutputRepresentation(null){

            public void write(OutputStream outputStream) throws IOException {
                try (InputStream stream = image.getStream();){
                    IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
                }
            }
        });
    }

    protected void handleNoTiles(Response res, Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body><center><h1>");
        if (e == null) {
            sb.append("No Tiling is available for this document</h1>");
        } else {
            sb.append("Picture Tiling can not be generated for this document</h1>");
            sb.append("<br/><pre>");
            sb.append(e.toString());
            sb.append("</pre>");
        }
        sb.append("</center></body></html>");
        res.setEntity(sb.toString(), MediaType.TEXT_HTML);
        HttpServletResponse response = PictureTilesRestlets.getHttpResponse((Response)res);
        response.setHeader("Content-Disposition", "inline");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCache(DocumentModel doc, PictureTilesAdapter adapter, String xpath) {
        Calendar modified = (Calendar)doc.getProperty("dublincore", "modified");
        PictureTilesCachedEntry entry = new PictureTilesCachedEntry(modified, adapter, xpath);
        Map<String, PictureTilesCachedEntry> map = cachedAdapters;
        synchronized (map) {
            cachedAdapters.put(doc.getId(), entry);
        }
        this.cacheGC();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromCache(String key) {
        PictureTilesCachedEntry entry = cachedAdapters.get(key);
        if (entry != null) {
            entry.getAdapter().cleanup();
        }
        Map<String, PictureTilesCachedEntry> map = cachedAdapters;
        synchronized (map) {
            cachedAdapters.remove(key);
        }
    }

    protected boolean isSameDate(Calendar d1, Calendar d2) {
        long t2;
        long t1 = d1.getTimeInMillis() / 1000L;
        return Math.abs(t1 - (t2 = d2.getTimeInMillis() / 1000L)) <= 1L;
    }

    protected PictureTilesAdapter getFromCache(DocumentModel doc, String xpath) {
        if (cachedAdapters.containsKey(doc.getId())) {
            if (xpath == null) {
                xpath = "";
            }
            Calendar modified = (Calendar)doc.getProperty("dublincore", "modified");
            PictureTilesCachedEntry entry = cachedAdapters.get(doc.getId());
            if (!this.isSameDate(entry.getModified(), modified) || !xpath.equals(entry.getXpath())) {
                this.removeFromCache(doc.getId());
                return null;
            }
            return entry.getAdapter();
        }
        return null;
    }

    protected void cacheGC() {
        for (String key : cachedAdapters.keySet()) {
            PictureTilesCachedEntry entry;
            long now = System.currentTimeMillis();
            if (now - (entry = cachedAdapters.get(key)).getTimeStamp() <= (long)(MAX_CACHE_LIFE * 1000)) continue;
        }
    }
}

