/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.api.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.adapter.DocumentAdapterFactory;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.api.PictureTilingService;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapter;
import org.nuxeo.ecm.platform.pictures.tiles.api.adapter.PictureTilesAdapterImpl;
import org.nuxeo.runtime.api.Framework;

public class PictureTilesAdapterFactory
implements DocumentAdapterFactory {
    private static final Log log = LogFactory.getLog(PictureTilesAdapterFactory.class);
    protected static final String ORIGINAL_JPEG_VIEW_NAME = "OriginalJpeg";
    @Deprecated
    protected static final String ORIGINAL_VIEW_NAME = "Original";

    public Object getAdapter(DocumentModel doc, Class itf) {
        block5: {
            PictureTilingService tilingService = (PictureTilingService)Framework.getService(PictureTilingService.class);
            String blobProperty = tilingService.getBlobProperty(doc.getType());
            try {
                PictureTilesAdapter ptAdapter = this.getPictureTilesAdapterFor(doc, blobProperty);
                if (ptAdapter != null) {
                    return ptAdapter;
                }
                if (doc.hasSchema("file")) {
                    Blob blob = (Blob)doc.getProperty("file", "content");
                    if (blob != null) {
                        PictureTilesAdapterImpl adapter = new PictureTilesAdapterImpl(doc, "file:content");
                        adapter.setFileName((String)doc.getProperty("file", "filename"));
                        return adapter;
                    }
                    break block5;
                }
                return new PictureTilesAdapterImpl(doc);
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get adapter", (Throwable)e);
            }
        }
        return null;
    }

    private PictureTilesAdapter getPictureTilesAdapterFor(DocumentModel doc, String blobProperty) throws ClientException {
        if (blobProperty != null) {
            try {
                return this.getPictureTilesAdapter(doc, blobProperty);
            }
            catch (IndexOutOfBoundsException | PropertyException e) {
                return this.getPictureTilesAdapterForPicture(doc);
            }
        }
        return this.getPictureTilesAdapterForPicture(doc);
    }

    private PictureTilesAdapter getPictureTilesAdapterForPicture(DocumentModel doc) throws ClientException {
        if (doc.hasSchema("picture")) {
            PictureResourceAdapter adapter = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            String blobProperty = adapter.getViewXPath(ORIGINAL_JPEG_VIEW_NAME) + "content";
            return this.getPictureTilesAdapter(doc, blobProperty);
        }
        return null;
    }

    private PictureTilesAdapter getPictureTilesAdapter(DocumentModel doc, String blobProperty) throws ClientException {
        Blob blob = (Blob)doc.getPropertyValue(blobProperty);
        if (blob != null) {
            PictureTilesAdapterImpl adapter = new PictureTilesAdapterImpl(doc, blobProperty);
            adapter.setFileName(blob.getFilename());
            return adapter;
        }
        return null;
    }
}

