/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.convert;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;
import org.nuxeo.ecm.platform.video.VideoInfo;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseVideoConversionConverter
extends CommandLineBasedConverter {
    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> stringSerializableMap) throws ConversionException {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        try {
            cmdBlobParams.put("inFilePath", blobHolder.getBlob());
        }
        catch (ClientException e) {
            throw new ConversionException("Unable to get Blob for holder", (Exception)((Object)e));
        }
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, String> cmdStringParams = new HashMap<String, String>();
        String baseDir = this.getTmpDirectory(parameters);
        Path tmpPath = new Path(baseDir).append(this.getTmpDirectoryPrefix() + "_" + UUID.randomUUID());
        File outDir = new File(tmpPath.toString());
        boolean dirCreated = outDir.mkdir();
        if (!dirCreated) {
            throw new ConversionException("Unable to create tmp dir for transformer output: " + outDir);
        }
        try {
            File outFile = File.createTempFile("videoConversion", this.getVideoExtension(), outDir);
            outFile.delete();
            Framework.trackFile((File)outFile, (Object)((Object)this));
            cmdStringParams.put("outFilePath", outFile.getAbsolutePath());
            String baseName = FilenameUtils.getBaseName((String)blobHolder.getBlob().getFilename());
            cmdStringParams.put("outFileName", baseName + this.getVideoExtension());
            VideoInfo videoInfo = (VideoInfo)parameters.get("videoInfo");
            if (videoInfo == null) {
                return cmdStringParams;
            }
            long width = videoInfo.getWidth();
            long height = videoInfo.getHeight();
            long newHeight = (Long)parameters.get("height");
            long newWidth = width * newHeight / height;
            if (newWidth % 2L != 0L) {
                ++newWidth;
            }
            cmdStringParams.put("width", String.valueOf(newWidth));
            cmdStringParams.put("height", String.valueOf(newHeight));
            return cmdStringParams;
        }
        catch (Exception e) {
            throw new ConversionException("Unable to get Blob for holder", e);
        }
    }

    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParameters) throws ConversionException {
        String outputPath = (String)cmdParameters.getParameters().get("outFilePath");
        File outputFile = new File(outputPath);
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        String outFileName = (String)cmdParameters.getParameters().get("outFileName");
        outFileName = outFileName == null ? outputFile.getName() : this.unquoteValue(outFileName);
        try {
            Blob blob = Blobs.createBlob((File)outputFile, (String)this.getVideoMimeType(), null, (String)outFileName);
            blobs.add(blob);
        }
        catch (IOException e) {
            throw new ConversionException("Cannot create blob", (Exception)e);
        }
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("cmdOutput", (Serializable)((Object)cmdOutput));
        return new SimpleBlobHolderWithProperties(blobs, properties);
    }

    protected String unquoteValue(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected abstract String getVideoMimeType();

    protected abstract String getVideoExtension();

    protected abstract String getTmpDirectoryPrefix();
}

