/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.gwt.client.util;

import org.nuxeo.ecm.platform.annotations.gwt.client.util.ImageRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.NullRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.StringRangeXPointer;
import org.nuxeo.ecm.platform.annotations.gwt.client.util.XPointer;

public class XPointerFactory {
    private static final String IMAGE_RANGE = "image-range";
    private static final String STRING_RANGE = "string-range";
    private static final String NULL_RANGE = "null-range";

    private XPointerFactory() {
    }

    public static XPointer getXPointer(String xpointer) {
        if (xpointer.contains(STRING_RANGE)) {
            return new StringRangeXPointer(xpointer);
        }
        if (xpointer.contains(IMAGE_RANGE)) {
            return new ImageRangeXPointer(xpointer);
        }
        if (xpointer.contains(NULL_RANGE)) {
            return new NullRangeXPointer(xpointer);
        }
        return null;
    }

    public static boolean isStringRange(String xpointer) {
        return xpointer.contains(STRING_RANGE);
    }

    public static boolean isImageRange(String xpointer) {
        return xpointer.contains(IMAGE_RANGE);
    }
}

