/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.adapter;

import java.io.File;
import java.io.IOException;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ThumbnailVideoFactory
implements ThumbnailFactory {
    public Blob getThumbnail(DocumentModel doc, CoreSession session) throws ClientException {
        if (!doc.hasFacet("Video")) {
            throw new ClientException("Document is not a video");
        }
        PictureResourceAdapter picResAdapter = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        Blob thumbnailView = picResAdapter.getPictureFromTitle("Small");
        if (thumbnailView == null && (thumbnailView = picResAdapter.getPictureFromTitle("Thumbnail")) == null) {
            TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
            try {
                return Blobs.createBlob((File)FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
        }
        return thumbnailView;
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        return null;
    }
}

