/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.convert.ConverterUtils;
import org.nuxeo.runtime.api.Framework;

public class CropPictureConverter
implements Converter {
    private static final Log log = LogFactory.getLog(CropPictureConverter.class);

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        try {
            ImagingService service = (ImagingService)Framework.getService(ImagingService.class);
            List sources = blobHolder.getBlobs();
            ArrayList<Blob> results = new ArrayList<Blob>(sources.size());
            Serializable h = parameters.get("height");
            int height = ConverterUtils.getInteger(h);
            Serializable w = parameters.get("width");
            int width = ConverterUtils.getInteger(w);
            Serializable xValue = parameters.get("x");
            int x = ConverterUtils.getInteger(xValue);
            Serializable yValue = parameters.get("y");
            int y = ConverterUtils.getInteger(yValue);
            for (Blob source : sources) {
                Blob result;
                if (source == null || (result = service.crop(source, x, y, width, height)) == null) continue;
                results.add(result);
            }
            return new SimpleCachableBlobHolder(results);
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            throw new ConversionException("Crop conversion has failed", (Exception)((Object)e));
        }
    }

    public void init(ConverterDescriptor descriptor) {
    }
}

