/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.web;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandAvailability;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.ecm.platform.picture.web.PictureManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.platform.ui.web.rest.RestHelper;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="pictureManager")
@Scope(value=ScopeType.CONVERSATION)
public class PictureManagerBean
implements PictureManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(PictureManagerBean.class);
    protected static Boolean imageMagickAvailable;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @RequestParameter
    protected String fileFieldFullName;
    @In(required=true, create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected ResourcesAccessor resourcesAccessor;
    protected String fileurlPicture;
    protected String filename;
    protected Blob fileContent;
    protected Integer index;
    protected String cropCoords;
    protected ArrayList<Map<String, Object>> selectItems;

    @Override
    @Create
    public void initialize() {
        log.debug((Object)"Initializing...");
        this.index = 0;
    }

    protected DocumentModel getCurrentDocument() {
        return this.navigationContext.getCurrentDocument();
    }

    @Override
    public String getFileurlPicture() throws ClientException {
        ArrayList views = (ArrayList)this.getCurrentDocument().getProperty("picture", "views");
        return ((Map)views.get(this.index)).get("title") + ":content";
    }

    @Override
    public void setFileurlPicture(String fileurlPicture) {
        this.fileurlPicture = fileurlPicture;
    }

    protected void initSelectItems() throws ClientException {
        this.selectItems = new ArrayList();
        DocumentModel doc = this.getCurrentDocument();
        ArrayList views = (ArrayList)doc.getProperty("picture", "views");
        for (int i = 0; i < views.size(); ++i) {
            HashMap map = new HashMap();
            map.put("title", ((Map)views.get(i)).get("title"));
            map.put("idx", i);
            this.selectItems.add(map);
        }
    }

    @Override
    public ArrayList getSelectItems() throws ClientException {
        if (this.selectItems == null) {
            this.initSelectItems();
            return this.selectItems;
        }
        return this.selectItems;
    }

    @Override
    public void setSelectItems(ArrayList selectItems) {
        this.selectItems = selectItems;
    }

    @Override
    @Deprecated
    public String addPicture() {
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        String parentPath = this.getCurrentDocument() == null ? this.documentManager.getRootDocument().getPathAsString() : this.navigationContext.getCurrentDocument().getPathAsString();
        String title = (String)doc.getProperty("dublincore", "title");
        if (title == null) {
            title = "";
        }
        doc.setPathInfo(parentPath, pss.generatePathSegment(doc));
        try {
            PictureResourceAdapter picture;
            boolean status;
            DocumentModel parent = this.getCurrentDocument();
            ArrayList pictureConversions = null;
            if (parent.getType().equals("PictureBook")) {
                pictureConversions = (ArrayList)parent.getProperty("picturebook", "picturetemplates");
            }
            if (!(status = (picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class)).fillPictureViews(this.fileContent, this.filename, title, pictureConversions))) {
                this.documentManager.cancel();
                log.info((Object)"Picture type unsupported.");
                FacesMessages.instance().add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.picture.upload.error"), new Object[0]);
                return this.navigationContext.getActionResult(this.navigationContext.getCurrentDocument(), UserAction.VIEW);
            }
            doc = this.documentManager.createDocument(doc);
            this.documentManager.saveDocument(doc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
            this.documentManager.save();
        }
        catch (IOException | ClientException e) {
            log.error((Object)"Picture Creation failed", e);
            this.documentManager.cancel();
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)((String)this.resourcesAccessor.getMessages().get("label.picture.upload.error")), (Object[])new Object[0]);
            FacesMessages.instance().add(message);
            return this.navigationContext.getActionResult(this.navigationContext.getCurrentDocument(), UserAction.VIEW);
        }
        return this.navigationContext.getActionResult(doc, UserAction.AFTER_CREATE);
    }

    @Override
    public String rotate90left() throws ClientException, IOException {
        DocumentModel doc = this.getCurrentDocument();
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        picture.doRotate(-90);
        this.documentManager.saveDocument(doc);
        this.documentManager.save();
        this.navigationContext.setCurrentDocument(doc);
        return null;
    }

    @Override
    public String rotate90right() throws ClientException, IOException {
        DocumentModel doc = this.getCurrentDocument();
        PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
        picture.doRotate(90);
        this.documentManager.saveDocument(doc);
        this.documentManager.save();
        this.navigationContext.setCurrentDocument(doc);
        return null;
    }

    @Override
    public String crop() throws ClientException, IOException {
        if (this.cropCoords != null && !this.cropCoords.equals("")) {
            DocumentModel doc = this.getCurrentDocument();
            PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            picture.doCrop(this.cropCoords);
            this.documentManager.saveDocument(doc);
            this.documentManager.save();
            this.navigationContext.setCurrentDocument(doc);
        }
        return null;
    }

    @Override
    @Observer(value={"documentSelectionChanged", "documentChanged"})
    @BypassInterceptors
    public void resetFields() {
        this.filename = "";
        this.fileContent = null;
        this.selectItems = null;
        this.index = 0;
        this.cropCoords = null;
    }

    @WebRemote
    public String remoteDownload(String patternName, String docID, String blobPropertyName, String filename) throws ClientException {
        IdRef docref = new IdRef(docID);
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)docref);
        return DocumentModelFunctions.fileUrl((String)patternName, (DocumentModel)doc, (String)blobPropertyName, (String)filename);
    }

    @WebRemote
    public static String urlPopup(String url) {
        return RestHelper.addCurrentConversationParameters((String)url);
    }

    @Override
    public void download(DocumentView docView) throws ClientException {
        if (docView != null) {
            DocumentModel doc;
            DocumentLocation docLoc = docView.getDocumentLocation();
            if (this.documentManager == null) {
                RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
                this.navigationContext.setCurrentServerLocation(loc);
                this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            }
            if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
                String[] propertyPath = docView.getParameter("FILE_PROPERTY_PATH").split(":");
                String title = null;
                String field = null;
                Property datamodel = null;
                if (propertyPath.length == 2) {
                    title = propertyPath[0];
                    field = propertyPath[1];
                    datamodel = doc.getProperty("picture:views");
                } else if (propertyPath.length == 3) {
                    String schema = propertyPath[0];
                    title = propertyPath[1];
                    field = propertyPath[2];
                    datamodel = doc.getProperty(schema + ":" + "views");
                }
                Property view = null;
                for (Property property : datamodel) {
                    if (!property.get("title").getValue().equals(title)) continue;
                    view = property;
                }
                if (view == null) {
                    for (Property property : datamodel) {
                        if (!property.get("title").getValue().equals("Thumbnail")) continue;
                        view = property;
                    }
                }
                if (view == null) {
                    return;
                }
                Blob blob = (Blob)view.getValue(field);
                String filename = (String)((Object)view.getValue("filename"));
                FacesContext context = FacesContext.getCurrentInstance();
                ComponentUtils.download((FacesContext)context, (Blob)blob, (String)filename);
            }
        }
    }

    @Override
    @Destroy
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
        this.fileurlPicture = null;
        this.filename = null;
        this.fileContent = null;
        this.index = null;
        this.selectItems = null;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public Blob getFileContent() {
        return this.fileContent;
    }

    @Override
    public void setFileContent(Blob fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(Integer index) {
        this.index = index;
    }

    @Override
    public String getCropCoords() {
        return this.cropCoords;
    }

    @Override
    public void setCropCoords(String cropCoords) {
        this.cropCoords = cropCoords;
    }

    public Boolean isImageMagickAvailable() {
        if (imageMagickAvailable == null) {
            CommandLineExecutorService cles = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
            CommandAvailability ca = cles.getCommandAvailability("cropAndResize");
            imageMagickAvailable = ca.isAvailable();
        }
        return imageMagickAvailable;
    }
}

