/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.rendition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProvider;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.rendition.VideoRenditionProvider;
import org.nuxeo.ecm.platform.video.service.VideoConversion;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;

public class VideoRenditionDefinitionProvider
implements RenditionDefinitionProvider {
    public List<RenditionDefinition> getRenditionDefinitions(DocumentModel doc) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        if (videoDocument == null) {
            return Collections.emptyList();
        }
        ArrayList<RenditionDefinition> renditionDefinitions = new ArrayList<RenditionDefinition>();
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        VideoService videoService = (VideoService)Framework.getService(VideoService.class);
        for (TranscodedVideo transcodedVideo : videoDocument.getTranscodedVideos()) {
            Blob blob;
            VideoConversion videoConversion = videoService.getVideoConversion(transcodedVideo.getName());
            if (videoConversion == null || !videoConversion.isRendition() || (blob = transcodedVideo.getBlob()) == null) continue;
            RenditionDefinition renditionDefinition = new RenditionDefinition();
            renditionDefinition.setEnabled(true);
            renditionDefinition.setName(transcodedVideo.getName());
            renditionDefinition.setProvider((RenditionProvider)new VideoRenditionProvider());
            renditionDefinition.setVisible(videoConversion.isRenditionVisible());
            renditionDefinition.setLabel(transcodedVideo.getName());
            MimetypeEntry mimeType = mimetypeRegistry.getMimetypeEntryByMimeType(blob.getMimeType());
            renditionDefinition.setIcon("/icons/" + mimeType.getIconPath());
            renditionDefinitions.add(renditionDefinition);
        }
        return renditionDefinitions;
    }
}

