/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.common.utils.UserAgentMatcher;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.VideoConversionStatus;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.service.VideoService;

@Name(value="videoActions")
@Install(precedence=10)
public class VideoActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true)
    protected VideoService videoService;

    public String getURLForPlayer(DocumentModel doc) throws ClientException {
        return DocumentModelFunctions.bigFileUrl((DocumentModel)doc, (String)"file:content", (String)"");
    }

    public String getTranscodedVideoURL(DocumentModel doc, String name) {
        TranscodedVideo transcodedVideo = this.getTranscodedVideo(doc, name);
        if (transcodedVideo == null) {
            return null;
        }
        String blobPropertyName = transcodedVideo.getBlobPropertyName();
        return DocumentModelFunctions.bigFileUrl((DocumentModel)doc, (String)blobPropertyName, (String)transcodedVideo.getBlob().getFilename());
    }

    public TranscodedVideo getTranscodedVideo(DocumentModel doc, String name) {
        VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
        return videoDocument.getTranscodedVideo(name);
    }

    public String getURLForStaticPreview(DocumentModel videoDoc) throws ClientException {
        String lastModification = "" + ((Calendar)videoDoc.getPropertyValue("dc:modified")).getTimeInMillis();
        return DocumentModelFunctions.fileUrl((String)"downloadPicture", (DocumentModel)videoDoc, (String)"StaticPlayerView:content", (String)lastModification);
    }

    public VideoConversionStatus getVideoConversionStatus(DocumentModel doc, String conversionName) {
        return this.videoService.getProgressStatus(doc.getRepositoryName(), doc.getId(), conversionName);
    }

    public String getStatusMessageFor(VideoConversionStatus status) {
        if (status == null) {
            return "";
        }
        String i18nMessageTemplate = this.messages.get(status.getMessage());
        if (i18nMessageTemplate == null) {
            return "";
        }
        return Interpolator.instance().interpolate(i18nMessageTemplate, new Object[]{status.positionInQueue, status.queueSize});
    }

    public void launchConversion(DocumentModel doc, String conversionName) {
        this.videoService.launchConversion(doc, conversionName);
    }

    public boolean isSafariHTML5() {
        return UserAgentMatcher.isSafari5((String)this.getUserAgent());
    }

    public boolean isChromeHTML5() {
        return UserAgentMatcher.isChrome((String)this.getUserAgent());
    }

    public boolean isFirefoxHTML5() {
        return UserAgentMatcher.isFirefox4OrMore((String)this.getUserAgent());
    }

    protected String getUserAgent() {
        ExternalContext econtext = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)econtext.getRequest();
        return request.getHeader("User-Agent");
    }
}

