/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image.tools;

import it.tidalwave.image.tools.TestInfo;
import it.tidalwave.image.tools.TestResults;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TestReportFormatter {
    private final File reportFile;
    private final File htmlFile;
    private List<TestInfo> tests = new ArrayList<TestInfo>();

    public TestReportFormatter(File reportFile, File htmlFile) {
        this.reportFile = reportFile;
        this.htmlFile = htmlFile;
    }

    public void run() throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new FileReader(this.reportFile));
        while ((s = br.readLine()) != null) {
            if ("".equals(s = s.split("#")[0].trim())) continue;
            String[] tmp = s.split("=");
            String body = tmp[0].trim();
            String value = tmp[1].trim();
            TestInfo testInfo = new TestInfo(body);
            TestResults testResults = new TestResults(body, value);
            int i = this.tests.indexOf(testInfo);
            if (i < 0) {
                this.tests.add(testInfo);
            } else {
                testInfo = this.tests.get(i);
            }
            testInfo.add(testResults);
        }
        br.close();
        Collections.sort(this.tests);
        PrintWriter pw = new PrintWriter(new FileWriter(this.htmlFile));
        pw.println("<table border='1' cellpadding='2' cellspacing='0'>");
        this.tests.get(0).printHeader(pw);
        for (TestInfo testInfo : this.tests) {
            testInfo.print(pw);
        }
        pw.println("</table>");
        pw.close();
    }

    public static void main(String[] args) throws IOException {
        new TestReportFormatter(new File("/Users/fritz/Business/Tidalwave/Projects/Mistral/trunk/src/EditableImage/TestReport.txt"), new File("/Users/fritz/Business/Tidalwave/Projects/Mistral/trunk/src/EditableImage/TestReport.html")).run();
    }
}

