/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.RenderedImage;

public final class ImageUtils {
    public static ICC_Profile getICCProfile(RenderedImage image) {
        ColorSpace colorSpace = image.getColorModel().getColorSpace();
        if (colorSpace instanceof ICC_ColorSpace) {
            ICC_ColorSpace iccColorSpace = (ICC_ColorSpace)colorSpace;
            return iccColorSpace.getProfile();
        }
        return null;
    }

    public static String getICCProfileName(ICC_Profile profile) {
        if (profile == null) {
            return null;
        }
        byte[] xx = profile.getData(1684370275);
        int offset = 12;
        int count = 1;
        while (xx[offset + count] != 0) {
            ++count;
        }
        return new String(xx, 0, offset, count);
    }
}

