/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.configuration.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.annotations.configuration.service.DisplayedFieldsDescriptor;
import org.nuxeo.ecm.platform.annotations.configuration.service.FilterDescriptor;
import org.nuxeo.ecm.platform.annotations.configuration.service.UserInfoMapperDescriptor;
import org.nuxeo.ecm.platform.annotations.configuration.service.WebAnnotationConfigurationService;
import org.nuxeo.ecm.platform.annotations.configuration.service.WebAnnotationDefinitionDescriptor;
import org.nuxeo.ecm.platform.annotations.configuration.service.WebPermissionDescriptor;
import org.nuxeo.ecm.platform.annotations.gwt.server.configuration.UserInfoMapper;
import org.nuxeo.ecm.platform.annotations.gwt.server.configuration.WebPermission;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebAnnotationConfigurationServiceImpl
extends DefaultComponent
implements WebAnnotationConfigurationService {
    private static final Log log = LogFactory.getLog(WebAnnotationConfigurationServiceImpl.class);
    private static final String ANNOTATION_TYPES_EXTENSION_POINT = "types";
    private static final String USER_INFO_EXTENSION_POINT = "userInfo";
    private static final String WEB_PERMISSION_EXTENSION_POINT = "webPermission";
    private static final String FILTERS_EXTENSION_POINT = "filters";
    private static final String DISPLAYED_FIELDS_EXTENSION_POINT = "displayedFields";
    private Map<String, WebAnnotationDefinitionDescriptor> annotationDefinitionsDescriptors;
    private UserInfoMapper userInfoMapper;
    private WebPermission webPermission;
    private Map<String, FilterDescriptor> filterDescriptors;
    private Set<String> displayedFields;
    private Map<String, String> fieldLabels;

    public void activate(ComponentContext context) throws Exception {
        this.annotationDefinitionsDescriptors = new HashMap<String, WebAnnotationDefinitionDescriptor>();
        this.filterDescriptors = new HashMap<String, FilterDescriptor>();
        this.displayedFields = new HashSet<String>();
        this.fieldLabels = new HashMap<String, String>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.annotationDefinitionsDescriptors = null;
        this.userInfoMapper = null;
        this.filterDescriptors = null;
        this.displayedFields = null;
        this.fieldLabels = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ANNOTATION_TYPES_EXTENSION_POINT.equals(extensionPoint)) {
            WebAnnotationDefinitionDescriptor descriptor = (WebAnnotationDefinitionDescriptor)contribution;
            if (this.annotationDefinitionsDescriptors.put(descriptor.getName(), descriptor) != null) {
                log.info((Object)("Already registered annotation type: " + descriptor.getName() + ", storing the new one."));
            }
        } else if (USER_INFO_EXTENSION_POINT.equals(extensionPoint)) {
            UserInfoMapperDescriptor descriptor = (UserInfoMapperDescriptor)contribution;
            this.userInfoMapper = descriptor.getKlass().newInstance();
        } else if (WEB_PERMISSION_EXTENSION_POINT.equals(extensionPoint)) {
            WebPermissionDescriptor descriptor = (WebPermissionDescriptor)contribution;
            this.webPermission = descriptor.getKlass().newInstance();
        } else if (FILTERS_EXTENSION_POINT.equals(extensionPoint)) {
            FilterDescriptor descriptor = (FilterDescriptor)contribution;
            if (this.filterDescriptors.put(descriptor.getName(), descriptor) != null) {
                log.info((Object)("Already registered annotation filter: " + descriptor.getName() + ", storing the new one."));
            }
        } else if (DISPLAYED_FIELDS_EXTENSION_POINT.equals(extensionPoint)) {
            DisplayedFieldsDescriptor descriptor = (DisplayedFieldsDescriptor)contribution;
            String fieldName = descriptor.getName();
            if (descriptor.isDisplayed()) {
                this.displayedFields.add(fieldName);
            } else {
                this.displayedFields.remove(fieldName);
            }
            String fieldLabel = descriptor.getLabel();
            if (fieldLabel != null) {
                this.fieldLabels.put(fieldName, fieldLabel);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ANNOTATION_TYPES_EXTENSION_POINT.equals(extensionPoint)) {
            WebAnnotationDefinitionDescriptor descriptor = (WebAnnotationDefinitionDescriptor)contribution;
            this.annotationDefinitionsDescriptors.remove(descriptor.getName());
        } else if (FILTERS_EXTENSION_POINT.equals(extensionPoint)) {
            FilterDescriptor descriptor = (FilterDescriptor)contribution;
            this.filterDescriptors.remove(descriptor.getName());
        } else if (DISPLAYED_FIELDS_EXTENSION_POINT.equals(extensionPoint)) {
            DisplayedFieldsDescriptor descriptor = (DisplayedFieldsDescriptor)contribution;
            String fieldName = descriptor.getName();
            this.displayedFields.remove(fieldName);
            this.fieldLabels.remove(fieldName);
        }
    }

    @Override
    public List<WebAnnotationDefinitionDescriptor> getAllWebAnnotationDefinitions() {
        return new ArrayList<WebAnnotationDefinitionDescriptor>(this.annotationDefinitionsDescriptors.values());
    }

    @Override
    public List<WebAnnotationDefinitionDescriptor> getEnabledWebAnnotationDefinitions() {
        ArrayList<WebAnnotationDefinitionDescriptor> definitions = new ArrayList<WebAnnotationDefinitionDescriptor>();
        for (WebAnnotationDefinitionDescriptor def : this.annotationDefinitionsDescriptors.values()) {
            if (!def.isEnabled().booleanValue()) continue;
            definitions.add(def);
        }
        return definitions;
    }

    @Override
    public UserInfoMapper getUserInfoMapper() {
        return this.userInfoMapper;
    }

    @Override
    public WebPermission getWebPermission() {
        return this.webPermission;
    }

    @Override
    public Map<String, FilterDescriptor> getFilterDefinitions() {
        return this.filterDescriptors;
    }

    @Override
    public Set<String> getDisplayedFields() {
        return this.displayedFields;
    }

    @Override
    public Map<String, String> getFieldLabels() {
        return this.fieldLabels;
    }
}

