/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.shared;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.shared.ServiceCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String BASE_URL_ATTRIBUTE = "org.apache.chemistry.opencmis.baseurl";
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    public static final String METHOD_PUT = "PUT";
    public static final String METHOD_DELETE = "DELETE";
    private static final Logger LOG = LoggerFactory.getLogger((String)Dispatcher.class.getName());
    private final boolean caseSensitive;
    private final Map<String, ServiceCall> serviceCallMap;

    public Dispatcher() {
        this(true);
    }

    public Dispatcher(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.serviceCallMap = new HashMap<String, ServiceCall>();
    }

    public void addResource(String resource, String httpMethod, ServiceCall serviceCall) {
        this.serviceCallMap.put(this.getKey(resource, httpMethod), serviceCall);
    }

    public boolean dispatch(String resource, String httpMethod, CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) {
        ServiceCall serviceCall = this.serviceCallMap.get(this.getKey(resource, httpMethod));
        if (serviceCall == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(repositoryId + " / " + resource + ", " + httpMethod + " -> " + serviceCall.getClass().getName());
        }
        try {
            serviceCall.serve(context, service, repositoryId, request, response);
        }
        catch (CmisBaseException ce) {
            throw ce;
        }
        catch (XMLStreamException xse) {
            throw new CmisInvalidArgumentException("Invalid XML!", (Throwable)xse);
        }
        catch (JSONParseException jpe) {
            throw new CmisInvalidArgumentException("Invalid JSON!", (Throwable)jpe);
        }
        catch (Exception e) {
            throw new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private String getKey(String resource, String httpMethod) {
        String s = resource + "/" + httpMethod;
        return this.caseSensitive ? s : s.toUpperCase();
    }
}

