/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.impl.json.JSONArray;
import org.apache.chemistry.opencmis.commons.impl.json.JSONObject;
import org.apache.chemistry.opencmis.commons.impl.json.JSONStreamAware;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.browser.AbstractBrowserServiceCall;
import org.apache.chemistry.opencmis.server.impl.browser.BrowserCallContextImpl;
import org.apache.chemistry.opencmis.server.impl.browser.ServerTypeCacheImpl;

public class PolicyService {

    public static class RemovePolicy
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String policyId = this.getStringParameter(request, "policyId");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            service.removePolicy(repositoryId, policyId, objectId, null);
            ObjectData object = this.getSimpleObject(service, repositoryId, objectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            response.setStatus(200);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class ApplyPolicy
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String policyId = this.getStringParameter(request, "policyId");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            service.applyPolicy(repositoryId, policyId, objectId, null);
            ObjectData object = this.getSimpleObject(service, repositoryId, objectId);
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            response.setStatus(200);
            ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
            JSONObject jsonObject = JSONConverter.convert((ObjectData)object, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct);
            this.writeJSON((JSONStreamAware)jsonObject, request, response);
        }
    }

    public static class GetAppliedPolicies
    extends AbstractBrowserServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = ((BrowserCallContextImpl)context).getObjectId();
            String filter = this.getStringParameter(request, "filter");
            boolean succinct = this.getBooleanParameter(request, "succinct", false);
            List policies = service.getAppliedPolicies(repositoryId, objectId, filter, null);
            JSONArray jsonPolicies = new JSONArray();
            if (policies != null) {
                ServerTypeCacheImpl typeCache = new ServerTypeCacheImpl(repositoryId, service);
                for (ObjectData policy : policies) {
                    jsonPolicies.add((Object)JSONConverter.convert((ObjectData)policy, (TypeCache)typeCache, (JSONConverter.PropertyMode)JSONConverter.PropertyMode.OBJECT, (boolean)succinct));
                }
            }
            response.setStatus(200);
            this.writeJSON((JSONStreamAware)jsonPolicies, request, response);
        }
    }
}

