/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisFilterNotValidException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisPermissionDeniedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStorageException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisStreamNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.ServerVersion;
import org.apache.chemistry.opencmis.server.impl.atompub.AclService;
import org.apache.chemistry.opencmis.server.impl.atompub.DiscoveryService;
import org.apache.chemistry.opencmis.server.impl.atompub.MultiFilingService;
import org.apache.chemistry.opencmis.server.impl.atompub.NavigationService;
import org.apache.chemistry.opencmis.server.impl.atompub.ObjectService;
import org.apache.chemistry.opencmis.server.impl.atompub.PolicyService;
import org.apache.chemistry.opencmis.server.impl.atompub.RelationshipService;
import org.apache.chemistry.opencmis.server.impl.atompub.RepositoryService;
import org.apache.chemistry.opencmis.server.impl.atompub.VersioningService;
import org.apache.chemistry.opencmis.server.shared.AbstractCmisHttpServlet;
import org.apache.chemistry.opencmis.server.shared.Dispatcher;
import org.apache.chemistry.opencmis.server.shared.ExceptionHelper;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.ServiceCall;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmisAtomPubServlet
extends AbstractCmisHttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(CmisAtomPubServlet.class);
    private static final long serialVersionUID = 1L;
    private final Dispatcher dispatcher = new Dispatcher();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.setBinding("atompub");
        String cmisVersionStr = config.getInitParameter("cmisVersion");
        if (cmisVersionStr != null) {
            try {
                this.setCmisVersion(CmisVersion.fromValue((String)cmisVersionStr));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("CMIS version is invalid! Setting it to CMIS 1.0.");
                this.setCmisVersion(CmisVersion.CMIS_1_0);
            }
        } else {
            LOG.warn("CMIS version is not defined! Setting it to CMIS 1.0.");
            this.setCmisVersion(CmisVersion.CMIS_1_0);
        }
        this.addResource("", "GET", new RepositoryService.GetRepositories());
        this.addResource("types", "GET", new RepositoryService.GetTypeChildren());
        this.addResource("types", "POST", new RepositoryService.CreateType());
        this.addResource("typedesc", "GET", new RepositoryService.GetTypeDescendants());
        this.addResource("type", "GET", new RepositoryService.GetTypeDefinition());
        this.addResource("type", "PUT", new RepositoryService.UpdateType());
        this.addResource("type", "DELETE", new RepositoryService.DeleteType());
        this.addResource("children", "GET", new NavigationService.GetChildren());
        this.addResource("descendants", "GET", new NavigationService.GetDescendants());
        this.addResource("foldertree", "GET", new NavigationService.GetFolderTree());
        this.addResource("parents", "GET", new NavigationService.GetObjectParents());
        this.addResource("checkedout", "GET", new NavigationService.GetCheckedOutDocs());
        this.addResource("entry", "GET", new ObjectService.GetObject());
        this.addResource("id", "GET", new ObjectService.GetObject());
        this.addResource("path", "GET", new ObjectService.GetObjectByPath());
        this.addResource("allowableactions", "GET", new ObjectService.GetAllowableActions());
        this.addResource("content", "GET", new ObjectService.GetContentStream());
        this.addResource("content", "PUT", new ObjectService.SetOrAppendContentStream());
        this.addResource("content", "DELETE", new ObjectService.DeleteContentStream());
        this.addResource("children", "POST", new ObjectService.Create());
        this.addResource("relationships", "POST", new ObjectService.CreateRelationship());
        this.addResource("entry", "PUT", new ObjectService.UpdateProperties());
        this.addResource("entry", "DELETE", new ObjectService.DeleteObject());
        this.addResource("children", "DELETE", new ObjectService.DeleteTree());
        this.addResource("descendants", "DELETE", new ObjectService.DeleteTree());
        this.addResource("foldertree", "DELETE", new ObjectService.DeleteTree());
        this.addResource("update", "POST", new ObjectService.BulkUpdateProperties());
        this.addResource("checkedout", "POST", new VersioningService.CheckOut());
        this.addResource("versions", "GET", new VersioningService.GetAllVersions());
        this.addResource("versions", "DELETE", new VersioningService.DeleteAllVersions());
        this.addResource("query", "GET", new DiscoveryService.Query());
        this.addResource("query", "POST", new DiscoveryService.Query());
        this.addResource("changes", "GET", new DiscoveryService.GetContentChanges());
        this.addResource("relationships", "GET", new RelationshipService.GetObjectRelationships());
        this.addResource("unfiled", "POST", new MultiFilingService.RemoveObjectFromFolder());
        this.addResource("acl", "GET", new AclService.GetAcl());
        this.addResource("acl", "PUT", new AclService.ApplyAcl());
        this.addResource("policies", "GET", new PolicyService.GetAppliedPolicies());
        this.addResource("policies", "POST", new PolicyService.ApplyPolicy());
        this.addResource("policies", "DELETE", new PolicyService.RemovePolicy());
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        QueryStringHttpServletRequestWrapper qsRequest = new QueryStringHttpServletRequestWrapper(request);
        response.addHeader("Cache-Control", "private, max-age=0");
        response.addHeader("Server", ServerVersion.OPENCMIS_SERVER);
        CallContext context = null;
        try {
            context = this.createContext(this.getServletContext(), (HttpServletRequest)qsRequest, response);
            this.dispatch(context, (HttpServletRequest)qsRequest, response);
        }
        catch (Exception e) {
            if (e instanceof CmisUnauthorizedException) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\"");
                response.sendError(401, "Authorization Required");
            }
            if (e instanceof CmisPermissionDeniedException) {
                if (context == null || context.getUsername() == null) {
                    response.setHeader("WWW-Authenticate", "Basic realm=\"CMIS\"");
                    response.sendError(401, "Authorization Required");
                } else {
                    response.sendError(this.getErrorCode((CmisBaseException)((CmisPermissionDeniedException)e)), e.getMessage());
                }
            }
            this.printError(e, response);
        }
        response.flushBuffer();
    }

    protected void addResource(String resource, String httpMethod, ServiceCall serviceCall) {
        this.dispatcher.addResource(resource, httpMethod, serviceCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(CallContext context, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CmisService service = null;
        try {
            String repositoryId;
            service = this.getServiceFactory().getService(context);
            String[] pathFragments = HttpUtils.splitPath(request);
            if (pathFragments.length < 2) {
                this.dispatcher.dispatch("", "GET", context, service, null, request, response);
                return;
            }
            String resource = pathFragments[1];
            String method = request.getMethod();
            boolean callServiceFound = this.dispatcher.dispatch(resource, method, context, service, repositoryId = pathFragments[0], request, response);
            if (!callServiceFound) {
                response.sendError(405, "Unknown operation");
            }
        }
        finally {
            if (service != null) {
                service.close();
            }
        }
    }

    protected int getErrorCode(CmisBaseException ex) {
        if (ex instanceof CmisConstraintException) {
            return 409;
        }
        if (ex instanceof CmisContentAlreadyExistsException) {
            return 409;
        }
        if (ex instanceof CmisFilterNotValidException) {
            return 400;
        }
        if (ex instanceof CmisInvalidArgumentException) {
            return 400;
        }
        if (ex instanceof CmisNameConstraintViolationException) {
            return 409;
        }
        if (ex instanceof CmisNotSupportedException) {
            return 405;
        }
        if (ex instanceof CmisObjectNotFoundException) {
            return 404;
        }
        if (ex instanceof CmisPermissionDeniedException) {
            return 403;
        }
        if (ex instanceof CmisStorageException) {
            return 500;
        }
        if (ex instanceof CmisStreamNotSupportedException) {
            return 403;
        }
        if (ex instanceof CmisUpdateConflictException) {
            return 409;
        }
        if (ex instanceof CmisVersioningException) {
            return 409;
        }
        return 500;
    }

    protected void printError(Exception ex, HttpServletResponse response) {
        int statusCode = 500;
        String exceptionName = "runtime";
        if (ex instanceof CmisRuntimeException) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        } else if (ex instanceof CmisBaseException) {
            statusCode = this.getErrorCode((CmisBaseException)ex);
            exceptionName = ((CmisBaseException)ex).getExceptionName();
        } else if (ex instanceof IOException) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        } else {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        if (response.isCommitted()) {
            LOG.warn("Failed to send error message to client. Response is already committed.", (Throwable)ex);
            return;
        }
        try {
            response.resetBuffer();
            response.setStatus(statusCode);
            response.setContentType("text/html");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            pw.print("<html><head><title>Apache Chemistry OpenCMIS - " + exceptionName + " error</title>" + "<style><!--H1 {font-size:24px;line-height:normal;font-weight:bold;background-color:#f0f0f0;color:#003366;border-bottom:1px solid #3c78b5;padding:2px;} " + "BODY {font-family:Verdana,arial,sans-serif;color:black;font-size:14px;} " + "HR {color:#3c78b5;height:1px;}--></style></head><body>");
            pw.print("<h1>HTTP Status " + statusCode + " - <!--exception-->" + exceptionName + "<!--/exception--></h1>");
            pw.print("<p><!--message-->" + StringEscapeUtils.escapeHtml((String)ex.getMessage()) + "<!--/message--></p>");
            String st = ExceptionHelper.getStacktraceAsString(ex);
            if (st != null) {
                pw.print("<hr noshade='noshade'/><!--stacktrace--><pre>\n" + st + "\n</pre><!--/stacktrace--><hr noshade='noshade'/>");
            }
            pw.print("</body></html>");
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                response.sendError(statusCode, ex.getMessage());
            }
            catch (Exception en) {
                // empty catch block
            }
        }
    }
}

