/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.PropertyId;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.TypeCache;
import org.apache.chemistry.opencmis.commons.server.CmisService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerTypeCacheImpl
implements TypeCache {
    private final String repositoryId;
    private final CmisService service;
    private final Map<String, TypeDefinition> typeDefinitions;
    private final Map<String, TypeDefinition> objectToTypeDefinitions;

    public ServerTypeCacheImpl(String repositoryId, CmisService service) {
        this.repositoryId = repositoryId;
        this.service = service;
        this.typeDefinitions = new HashMap<String, TypeDefinition>();
        this.objectToTypeDefinitions = new HashMap<String, TypeDefinition>();
    }

    public TypeDefinition getTypeDefinition(String typeId) {
        TypeDefinition type = this.typeDefinitions.get(typeId);
        if (type == null && (type = this.service.getTypeDefinition(this.repositoryId, typeId, null)) != null) {
            this.typeDefinitions.put(type.getId(), type);
        }
        return type;
    }

    public TypeDefinition getTypeDefinitionForObject(String objectId) {
        TypeDefinition type = this.objectToTypeDefinitions.get(objectId);
        if (type == null) {
            ObjectData obj = this.service.getObject(this.repositoryId, objectId, "cmis:objectId,cmis:objectTypeId,cmis:baseTypeId,cmis:secondaryObjectTypeIds", Boolean.valueOf(false), IncludeRelationships.NONE, "cmis:none", Boolean.valueOf(false), Boolean.valueOf(false), null);
            if (obj != null && obj.getProperties() != null) {
                PropertyData secTypeProp;
                String typeId;
                PropertyData typeProp = (PropertyData)obj.getProperties().getProperties().get("cmis:objectTypeId");
                if (typeProp instanceof PropertyId && (typeId = (String)((PropertyId)typeProp).getFirstValue()) != null) {
                    type = this.getTypeDefinition(typeId);
                }
                if ((secTypeProp = (PropertyData)obj.getProperties().getProperties().get("cmis:secondaryObjectTypeIds")) instanceof PropertyId && secTypeProp.getValues() != null) {
                    for (String secTypeId : ((PropertyId)secTypeProp).getValues()) {
                        if (secTypeId == null) continue;
                        this.getTypeDefinition(secTypeId);
                    }
                }
            }
            this.objectToTypeDefinitions.put(objectId, type);
        }
        return type;
    }

    public PropertyDefinition<?> getPropertyDefinition(String propId) {
        for (TypeDefinition typeDef : this.typeDefinitions.values()) {
            PropertyDefinition propDef = (PropertyDefinition)typeDef.getPropertyDefinitions().get(propId);
            if (propDef == null) continue;
            return propDef;
        }
        return null;
    }
}

