/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.stream.XMLStreamException;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.LinkInfo;
import org.apache.chemistry.opencmis.commons.server.NamespaceDefinitions;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.RenditionInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.shared.AbstractServiceCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAtomPubServiceCall
extends AbstractServiceCall {
    public static final String RESOURCE_CHILDREN = "children";
    public static final String RESOURCE_DESCENDANTS = "descendants";
    public static final String RESOURCE_FOLDERTREE = "foldertree";
    public static final String RESOURCE_TYPE = "type";
    public static final String RESOURCE_TYPES = "types";
    public static final String RESOURCE_TYPESDESC = "typedesc";
    public static final String RESOURCE_ENTRY = "entry";
    public static final String RESOURCE_PARENTS = "parents";
    public static final String RESOURCE_VERSIONS = "versions";
    public static final String RESOURCE_ALLOWABLEACIONS = "allowableactions";
    public static final String RESOURCE_ACL = "acl";
    public static final String RESOURCE_POLICIES = "policies";
    public static final String RESOURCE_RELATIONSHIPS = "relationships";
    public static final String RESOURCE_OBJECTBYID = "id";
    public static final String RESOURCE_OBJECTBYPATH = "path";
    public static final String RESOURCE_QUERY = "query";
    public static final String RESOURCE_CHECKEDOUT = "checkedout";
    public static final String RESOURCE_UNFILED = "unfiled";
    public static final String RESOURCE_CHANGES = "changes";
    public static final String RESOURCE_CONTENT = "content";
    public static final String RESOURCE_BULK_UPDATE = "update";
    public static final String REPOSITORY_PLACEHOLDER = "{repositoryId}";
    public static final BigInteger PAGE_SIZE = BigInteger.valueOf(100L);
    public static final String TYPE_AUTHOR = "unknown";

    public UrlBuilder compileBaseUrl(HttpServletRequest request, String repositoryId) {
        String baseUrl = (String)request.getAttribute("org.apache.chemistry.opencmis.baseurl");
        if (baseUrl != null) {
            int repIdPos = baseUrl.indexOf(REPOSITORY_PLACEHOLDER);
            if (repIdPos < 0) {
                return new UrlBuilder(baseUrl);
            }
            return new UrlBuilder(baseUrl.substring(0, repIdPos) + repositoryId + baseUrl.substring(repIdPos + REPOSITORY_PLACEHOLDER.length()));
        }
        UrlBuilder url = new UrlBuilder(request.getScheme(), request.getServerName(), request.getServerPort(), null);
        url.addPath(request.getContextPath());
        url.addPath(request.getServletPath());
        if (repositoryId != null) {
            url.addPathSegment(repositoryId);
        }
        return url;
    }

    public String compileUrl(UrlBuilder baseUrl, String resource, String id) {
        return this.compileUrlBuilder(baseUrl, resource, id).toString();
    }

    public UrlBuilder compileUrlBuilder(UrlBuilder baseUrl, String resource, String id) {
        UrlBuilder url = new UrlBuilder(baseUrl);
        url.addPathSegment(resource);
        if (id != null) {
            url.addParameter(RESOURCE_OBJECTBYID, (Object)id);
        }
        return url;
    }

    public Map<String, String> getNamespaces(Object obj) {
        if (obj instanceof NamespaceDefinitions) {
            return ((NamespaceDefinitions)obj).getNamespaces();
        }
        return null;
    }

    public void writeObjectEntry(CmisService service, AtomEntry entry, ObjectData object, List<ObjectInFolderContainer> children, String repositoryId, String pathSegment, String relativePathSegment, UrlBuilder baseUrl, boolean isRoot, CmisVersion cmisVersion) throws XMLStreamException {
        if (object == null) {
            throw new CmisRuntimeException("Object not set!");
        }
        ObjectInfo info = service.getObjectInfo(repositoryId, object.getId());
        if (info == null) {
            throw new CmisRuntimeException("Object Info not found for: " + object.getId());
        }
        entry.startEntry(isRoot);
        String contentSrc = null;
        if (info.hasContent()) {
            UrlBuilder contentSrcBuilder = this.compileUrlBuilder(baseUrl, RESOURCE_CONTENT, info.getId());
            if (info.getFileName() != null) {
                contentSrcBuilder.addPathSegment(info.getFileName());
            }
            contentSrc = contentSrcBuilder.toString();
        }
        entry.writeObject(object, info, contentSrc, info.getContentType(), pathSegment, relativePathSegment, cmisVersion);
        entry.writeServiceLink(baseUrl.toString(), repositoryId);
        entry.writeSelfLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, info.getId()), info.getId());
        entry.writeEnclosureLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, info.getId()));
        entry.writeEditLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, info.getId()));
        entry.writeDescribedByLink(this.compileUrl(baseUrl, RESOURCE_TYPE, info.getTypeId()));
        entry.writeAllowableActionsLink(this.compileUrl(baseUrl, RESOURCE_ALLOWABLEACIONS, info.getId()));
        if (info.hasParent()) {
            entry.writeUpLink(this.compileUrl(baseUrl, RESOURCE_PARENTS, info.getId()), "application/atom+xml;type=feed");
        }
        if (info.getBaseType() == BaseTypeId.CMIS_FOLDER) {
            entry.writeDownLink(this.compileUrl(baseUrl, RESOURCE_CHILDREN, info.getId()), "application/atom+xml;type=feed");
            if (info.supportsDescendants()) {
                entry.writeDownLink(this.compileUrl(baseUrl, RESOURCE_DESCENDANTS, info.getId()), "application/cmistree+xml");
            }
            if (info.supportsFolderTree()) {
                entry.writeFolderTreeLink(this.compileUrl(baseUrl, RESOURCE_FOLDERTREE, info.getId()));
            }
        }
        if (info.getVersionSeriesId() != null) {
            UrlBuilder vsUrl = this.compileUrlBuilder(baseUrl, RESOURCE_VERSIONS, info.getId());
            vsUrl.addParameter("versionSeries", (Object)info.getVersionSeriesId());
            entry.writeVersionHistoryLink(vsUrl.toString());
        }
        if (!info.isCurrentVersion()) {
            UrlBuilder cvUrl = this.compileUrlBuilder(baseUrl, RESOURCE_ENTRY, info.getId());
            cvUrl.addParameter("returnVersion", (Object)ReturnVersion.LATEST);
            entry.writeEditLink(cvUrl.toString());
        }
        if (info.getBaseType() == BaseTypeId.CMIS_DOCUMENT) {
            entry.writeEditMediaLink(this.compileUrl(baseUrl, RESOURCE_CONTENT, info.getId()), info.getContentType());
        }
        if (info.getWorkingCopyId() != null) {
            entry.writeWorkingCopyLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, info.getWorkingCopyId()));
        }
        if (info.getWorkingCopyOriginalId() != null) {
            entry.writeViaLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, info.getWorkingCopyOriginalId()));
        }
        if (info.getRenditionInfos() != null) {
            for (RenditionInfo ri : info.getRenditionInfos()) {
                UrlBuilder rurl = this.compileUrlBuilder(baseUrl, RESOURCE_CONTENT, info.getId());
                rurl.addParameter("streamId", (Object)ri.getId());
                entry.writeAlternateLink(rurl.toString(), ri.getContenType(), ri.getKind(), ri.getTitle(), ri.getLength());
            }
        }
        if (info.hasAcl()) {
            entry.writeAclLink(this.compileUrl(baseUrl, RESOURCE_ACL, info.getId()));
        }
        if (info.supportsPolicies()) {
            entry.writePoliciesLink(this.compileUrl(baseUrl, RESOURCE_POLICIES, info.getId()));
        }
        if (info.supportsRelationships()) {
            entry.writeRelationshipsLink(this.compileUrl(baseUrl, RESOURCE_RELATIONSHIPS, info.getId()));
        }
        if (info.getRelationshipSourceIds() != null) {
            for (String id : info.getRelationshipSourceIds()) {
                entry.writeRelationshipSourceLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, id));
            }
        }
        if (info.getRelationshipTargetIds() != null) {
            for (String id : info.getRelationshipTargetIds()) {
                entry.writeRelationshipTargetLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, id));
            }
        }
        if (info.getAdditionalLinks() != null) {
            for (LinkInfo linkInfo : info.getAdditionalLinks()) {
                entry.writeLink(linkInfo.getRel(), linkInfo.getHref(), linkInfo.getType(), linkInfo.getId());
            }
        }
        if (children != null && children.size() > 0) {
            this.writeObjectChildren(service, entry, info, children, repositoryId, baseUrl, cmisVersion);
        }
        entry.endEntry();
    }

    public void writeContentChangesObjectEntry(CmisService service, AtomEntry entry, ObjectData object, List<ObjectInFolderContainer> children, String repositoryId, String pathSegment, String relativePathSegment, UrlBuilder baseUrl, boolean isRoot, CmisVersion cmisVersion) throws XMLStreamException {
        if (object == null) {
            throw new CmisRuntimeException("Object not set!");
        }
        ObjectInfo info = null;
        try {
            info = service.getObjectInfo(repositoryId, object.getId());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (info != null) {
            this.writeObjectEntry(service, entry, object, children, repositoryId, pathSegment, relativePathSegment, baseUrl, isRoot, cmisVersion);
            return;
        }
        entry.startEntry(isRoot);
        entry.writeDeletedObject(object, cmisVersion);
        entry.writeServiceLink(baseUrl.toString(), repositoryId);
        entry.endEntry();
    }

    public void writeObjectChildren(CmisService service, AtomEntry entry, ObjectInfo folderInfo, List<ObjectInFolderContainer> children, String repositoryId, UrlBuilder baseUrl, CmisVersion cmisVersion) throws XMLStreamException {
        AtomFeed feed = new AtomFeed(entry.getWriter());
        feed.startChildren();
        feed.startFeed(false);
        feed.writeFeedElements(folderInfo.getId(), folderInfo.getAtomId(), folderInfo.getCreatedBy(), folderInfo.getName(), folderInfo.getLastModificationDate(), null, null);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        feed.writeSelfLink(this.compileUrl(baseUrl, RESOURCE_DESCENDANTS, folderInfo.getId()), null);
        feed.writeViaLink(this.compileUrl(baseUrl, RESOURCE_ENTRY, folderInfo.getId()));
        feed.writeDownLink(this.compileUrl(baseUrl, RESOURCE_CHILDREN, folderInfo.getId()), "application/atom+xml;type=feed");
        feed.writeDownLink(this.compileUrl(baseUrl, RESOURCE_FOLDERTREE, folderInfo.getId()), "application/cmistree+xml");
        feed.writeUpLink(this.compileUrl(baseUrl, RESOURCE_PARENTS, folderInfo.getId()), "application/atom+xml;type=feed");
        for (ObjectInFolderContainer container : children) {
            if (container == null || container.getObject() == null) continue;
            this.writeObjectEntry(service, entry, container.getObject().getObject(), container.getChildren(), repositoryId, container.getObject().getPathSegment(), null, baseUrl, false, cmisVersion);
        }
        feed.endFeed();
        feed.endChildren();
    }

    public void writeTypeEntry(AtomEntry entry, TypeDefinition type, List<TypeDefinitionContainer> children, String repositoryId, UrlBuilder baseUrl, boolean isRoot, CmisVersion cmisVersion) throws XMLStreamException {
        entry.startEntry(isRoot);
        entry.writeType(type, cmisVersion);
        entry.writeServiceLink(baseUrl.toString(), repositoryId);
        entry.writeSelfLink(this.compileUrl(baseUrl, RESOURCE_TYPE, type.getId()), type.getId());
        entry.writeEnclosureLink(this.compileUrl(baseUrl, RESOURCE_TYPE, type.getId()));
        if (type.getParentTypeId() != null) {
            entry.writeUpLink(this.compileUrl(baseUrl, RESOURCE_TYPE, type.getParentTypeId()), "application/atom+xml;type=entry");
        }
        UrlBuilder downLink = this.compileUrlBuilder(baseUrl, RESOURCE_TYPES, null);
        downLink.addParameter("typeId", (Object)type.getId());
        entry.writeDownLink(downLink.toString(), "application/atom+xml;type=feed");
        UrlBuilder downLink2 = this.compileUrlBuilder(baseUrl, RESOURCE_TYPESDESC, null);
        downLink2.addParameter("typeId", (Object)type.getId());
        entry.writeDownLink(downLink2.toString(), "application/cmistree+xml");
        entry.writeDescribedByLink(this.compileUrl(baseUrl, RESOURCE_TYPE, type.getBaseTypeId().value()));
        if (children != null && children.size() > 0) {
            this.writeTypeChildren(entry, type, children, repositoryId, baseUrl, cmisVersion);
        }
        entry.endEntry();
    }

    private void writeTypeChildren(AtomEntry entry, TypeDefinition type, List<TypeDefinitionContainer> children, String repositoryId, UrlBuilder baseUrl, CmisVersion cmisVersion) throws XMLStreamException {
        AtomFeed feed = new AtomFeed(entry.getWriter());
        feed.startChildren();
        feed.startFeed(false);
        feed.writeFeedElements(type.getId(), null, TYPE_AUTHOR, type.getDisplayName(), new GregorianCalendar(), null, null);
        feed.writeServiceLink(baseUrl.toString(), repositoryId);
        UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, RESOURCE_TYPESDESC, null);
        selfLink.addParameter("typeId", (Object)type.getId());
        feed.writeSelfLink(selfLink.toString(), type.getId());
        feed.writeViaLink(this.compileUrl(baseUrl, RESOURCE_TYPE, type.getId()));
        UrlBuilder downLink = this.compileUrlBuilder(baseUrl, RESOURCE_TYPES, null);
        downLink.addParameter("typeId", (Object)type.getId());
        feed.writeDownLink(downLink.toString(), "application/atom+xml;type=feed");
        if (type.getParentTypeId() != null) {
            feed.writeUpLink(this.compileUrl(baseUrl, RESOURCE_TYPE, type.getParentTypeId()), "application/atom+xml;type=entry");
        }
        for (TypeDefinitionContainer container : children) {
            if (container == null || container.getTypeDefinition() == null) continue;
            this.writeTypeEntry(entry, container.getTypeDefinition(), container.getChildren(), repositoryId, baseUrl, false, cmisVersion);
        }
        feed.writeExtensions((ExtensionsData)type);
        feed.endFeed();
        feed.endChildren();
    }
}

