/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.seam;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.dam.provider.ImportFolderPageProvider;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.DataModelProperties;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.dnd.DndConfigurationHelper;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.model.UploadItem;

@Name(value="damImportActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamImportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DamImportActions.class);
    protected static Random random = new Random();
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient DndConfigurationHelper dndConfigHelper;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected DocumentModel importDocumentModel;
    protected Action selectedImportOption;
    protected List<Action> importOptions;
    protected String selectedImportFolderId;
    protected String currentBatchId;
    protected Collection<UploadItem> uploadedFiles = null;
    protected String selectedNewAssetType;

    public DocumentModel getImportDocumentModel() {
        if (this.importDocumentModel == null) {
            this.importDocumentModel = new SimpleDocumentModel();
        }
        return this.importDocumentModel;
    }

    public String getSelectedImportOptionId() {
        if (this.selectedImportOption == null) {
            this.selectedImportOption = this.importOptions != null && this.importOptions.size() > 0 ? this.importOptions.get(0) : null;
        }
        return this.selectedImportOption != null ? this.selectedImportOption.getId() : null;
    }

    public void setSelectedImportOptionId(String id) {
        for (Action importOption : this.importOptions) {
            if (!importOption.getId().equals(id)) continue;
            this.selectedImportOption = importOption;
            break;
        }
    }

    public Action getSelectedImportOption() {
        if (this.selectedImportOption == null) {
            this.selectedImportOption = this.importOptions != null && this.importOptions.size() > 0 ? this.importOptions.get(0) : null;
        }
        return this.selectedImportOption;
    }

    public List<Action> getImportOptions(String dropContext) {
        if (this.importOptions == null) {
            this.importOptions = new ArrayList<Action>();
            this.importOptions.addAll(this.webActions.getActionsList(dropContext));
        }
        return this.importOptions;
    }

    public String getSelectedImportFolderId() throws ClientException {
        DocumentModel doc;
        PathRef ref;
        DamService damService;
        AssetLibrary assetLibrary;
        if (this.selectedImportFolderId == null && (assetLibrary = (damService = (DamService)Framework.getLocalService(DamService.class)).getAssetLibrary()) != null && this.documentManager.exists((DocumentRef)(ref = new PathRef(damService.getAssetLibrary().getPath()))) && ImportFolderPageProvider.COMPOUND_FILTER.accept(doc = this.documentManager.getDocument((DocumentRef)ref))) {
            this.selectedImportFolderId = doc.getId();
        }
        return this.selectedImportFolderId;
    }

    public void setSelectedImportFolderId(String selectedImportFolderId) {
        this.selectedImportFolderId = selectedImportFolderId;
    }

    public List<Type> getSubTypesFor(DocumentModel doc) {
        TypeManager typeManager = (TypeManager)Framework.getLocalService(TypeManager.class);
        ArrayList<Type> types = new ArrayList<Type>();
        TypeInfo typeInfo = (TypeInfo)doc.getAdapter(TypeInfo.class);
        for (String typeName : typeInfo.getAllowedSubTypes().keySet()) {
            types.add(typeManager.getType(typeName));
        }
        return types;
    }

    public List<Type> getAllowedImportFolderSubTypes() throws ClientException {
        if (StringUtils.isBlank((String)this.selectedImportFolderId)) {
            return Collections.emptyList();
        }
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(this.selectedImportFolderId));
        TypeManager typeManager = (TypeManager)Framework.getLocalService(TypeManager.class);
        DamService damService = (DamService)Framework.getLocalService(DamService.class);
        List<Type> allowedAssetTypes = damService.getAllowedAssetTypes();
        Collection allowedSubTypes = typeManager.getAllowedSubTypes(doc.getType(), doc);
        ArrayList<Type> types = new ArrayList<Type>();
        for (Type type : allowedAssetTypes) {
            if (!allowedSubTypes.contains(type)) continue;
            types.add(type);
        }
        return types;
    }

    public String generateBatchId() {
        if (this.currentBatchId == null) {
            this.currentBatchId = "batch-" + new Date().getTime() + "-" + random.nextInt(1000);
        }
        return this.currentBatchId;
    }

    public boolean hasUploadedFiles() {
        if (this.currentBatchId != null) {
            BatchManager batchManager = (BatchManager)Framework.getLocalService(BatchManager.class);
            return batchManager.hasBatch(this.currentBatchId);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String importAssets() throws ClientException {
        Map importOptionProperties = this.selectedImportOption.getProperties();
        String chainOrOperationId = null;
        chainOrOperationId = importOptionProperties.containsKey("chainId") ? (String)importOptionProperties.get("chainId") : (importOptionProperties.containsKey("operationId") ? (String)importOptionProperties.get("operationId") : this.selectedImportOption.getId());
        ArrayList<DataModel> dms = new ArrayList<DataModel>();
        for (String schema : this.importDocumentModel.getSchemas()) {
            dms.add(this.importDocumentModel.getDataModel(schema));
        }
        DataModelProperties properties = new DataModelProperties(dms, true);
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        contextParams.put("docMetaData", properties);
        contextParams.put("currentDocument", this.selectedImportFolderId);
        try {
            if (this.dndConfigHelper.useHtml5DragAndDrop()) {
                this.importAssetsThroughBatchManager(chainOrOperationId, contextParams);
            } else {
                this.importAssetsThroughUploadItems(chainOrOperationId, contextParams);
            }
        }
        finally {
            this.cancel();
        }
        return null;
    }

    protected void importAssetsThroughBatchManager(String chainOrOperationId, Map<String, Object> contextParams) throws ClientException {
        BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
        bm.executeAndClean(this.currentBatchId, chainOrOperationId, this.documentManager, contextParams, null);
    }

    protected void importAssetsThroughUploadItems(String chainOrOperationId, Map<String, Object> contextParams) throws ClientException {
        if (this.uploadedFiles == null) {
            return;
        }
        try {
            ArrayList<Blob> blobs = new ArrayList<Blob>();
            for (UploadItem uploadItem : this.uploadedFiles) {
                String filename = FileUtils.getCleanFileName((String)uploadItem.getFileName());
                Blob blob = FileUtils.createTemporaryFileBlob((File)uploadItem.getFile(), (String)filename, (String)uploadItem.getContentType());
                blobs.add(blob);
            }
            OperationContext ctx = new OperationContext(this.documentManager);
            ctx.setInput((Object)new BlobList(blobs));
            ctx.putAll(contextParams);
            AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
            if (chainOrOperationId.startsWith("Chain.")) {
                as.run(ctx, chainOrOperationId.substring(6));
            } else {
                OperationChain chain = new OperationChain("operation");
                OperationParameters params = new OperationParameters(chainOrOperationId, new HashMap());
                chain.add(params);
                as.run(ctx, chain);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while executing automation batch ", (Throwable)e);
            throw ClientException.wrap((Throwable)e);
        }
        finally {
            for (UploadItem uploadItem : this.getUploadedFiles()) {
                File tempFile = uploadItem.getFile();
                if (tempFile == null || !tempFile.exists()) continue;
                Framework.trackFile((File)tempFile, (Object)tempFile);
            }
            this.uploadedFiles = null;
        }
    }

    public void cancel() {
        if (this.currentBatchId != null) {
            BatchManager bm = (BatchManager)Framework.getLocalService(BatchManager.class);
            bm.clean(this.currentBatchId);
        }
        this.importDocumentModel = null;
        this.selectedImportFolderId = null;
        this.uploadedFiles = null;
        this.currentBatchId = null;
    }

    public Collection<UploadItem> getUploadedFiles() {
        if (this.uploadedFiles == null) {
            this.uploadedFiles = new ArrayList<UploadItem>();
        }
        return this.uploadedFiles;
    }

    public void setUploadedFiles(Collection<UploadItem> uploadedFiles) {
        this.uploadedFiles = uploadedFiles;
    }

    public String getSelectedNewAssetType() throws ClientException {
        if (this.selectedNewAssetType == null) {
            List<Type> allowedAssetTypes = this.getAllowedImportFolderSubTypes();
            if (!allowedAssetTypes.isEmpty()) {
                this.selectedNewAssetType = allowedAssetTypes.get(0).getId();
            }
            if (this.selectedNewAssetType != null) {
                this.selectNewAssetType();
            }
        }
        return this.selectedNewAssetType;
    }

    public void setSelectedNewAssetType(String selectedNewAssetType) {
        this.selectedNewAssetType = selectedNewAssetType;
    }

    public void selectNewAssetType() throws ClientException {
        String selectedType = this.getSelectedNewAssetType();
        if (selectedType == null) {
            return;
        }
        HashMap context = new HashMap();
        DocumentModel changeableDocument = this.documentManager.createDocumentModel(selectedType, context);
        this.navigationContext.setChangeableDocument(changeableDocument);
    }

    public void saveNewAsset() throws ClientException {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        if (StringUtils.isBlank((String)this.selectedImportFolderId) || changeableDocument.getId() != null) {
            return;
        }
        PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(this.selectedImportFolderId));
        changeableDocument.setPathInfo(doc.getPathAsString(), pss.generatePathSegment(changeableDocument));
        changeableDocument = this.documentManager.createDocument(changeableDocument);
        this.documentManager.save();
        this.cancelNewAsset();
        Events.instance().raiseEvent("refreshDamSearch", new Object[0]);
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("document_saved"), new Object[]{this.messages.get(changeableDocument.getType())});
    }

    public void cancelNewAsset() {
        this.selectedImportFolderId = null;
        this.navigationContext.setChangeableDocument(null);
        this.setSelectedNewAssetType(null);
    }
}

