/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam.seam;

import java.io.Serializable;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.webapp.action.MainTabsActions;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="damActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class DamActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MAIN_TABS_DAM = "MAIN_TABS:dam";
    public static final String MAIN_TABS_DOCUMENT_MANAGEMENT = "MAIN_TABS:documents";
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient MainTabsActions mainTabsActions;

    public String getSelectedDocumentId() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument != null ? currentDocument.getId() : null;
    }

    public void setSelectedDocumentId(String selectedDocumentId) throws ClientException {
        DocumentModel selectedDocument = this.documentManager.getDocument((DocumentRef)new IdRef(selectedDocumentId));
        this.selectDocument(selectedDocument);
    }

    public void selectDocument(DocumentModel doc) throws ClientException {
        this.navigationContext.setCurrentDocument(doc);
        this.mainTabsActions.setDocumentFor("dam", doc);
    }

    public String getDamMainTab() {
        return MAIN_TABS_DAM;
    }

    public void setDamMainTab(String tabs) {
        this.webActions.setCurrentTabIds(!StringUtils.isBlank((String)tabs) ? tabs : MAIN_TABS_DAM);
    }

    public String viewInDM() throws ClientException {
        this.webActions.setCurrentTabIds(MAIN_TABS_DOCUMENT_MANAGEMENT);
        return this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
    }

    public String viewInDAM() throws ClientException {
        this.webActions.setCurrentTabIds(MAIN_TABS_DAM);
        this.navigationContext.navigateToDocument(this.navigationContext.getCurrentDocument());
        return "asset";
    }

    public String updateCurrentDocument() throws ClientException {
        this.documentActions.updateCurrentDocument();
        return null;
    }

    public boolean getCanCreateInAssetLibrary() throws ClientException {
        AssetLibrary assetLibrary = this.getAssetLibrary();
        PathRef assetLibraryRef = new PathRef(assetLibrary.getPath());
        return this.documentManager.hasPermission((DocumentRef)assetLibraryRef, "AddChildren");
    }

    public AssetLibrary getAssetLibrary() {
        return ((DamService)Framework.getLocalService(DamService.class)).getAssetLibrary();
    }

    public boolean isOnDamView() {
        String viewId;
        if (FacesContext.getCurrentInstance() == null) {
            return false;
        }
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        return viewRoot != null && ("/dam/assets.xhtml".equals(viewId = viewRoot.getViewId()) || "/dam/asset.xhtml".equals(viewId));
    }

    public boolean isOnAssetsView() {
        String viewId;
        if (FacesContext.getCurrentInstance() == null) {
            return false;
        }
        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        return viewRoot != null && "/dam/assets.xhtml".equals(viewId = viewRoot.getViewId());
    }

    public String getDownloadURL() {
        return DocumentModelFunctions.bigFileUrl((DocumentModel)this.navigationContext.getCurrentDocument(), (String)"blobholder:0", (String)"");
    }
}

