/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav.util;

public class WavFormatHeader {
    private boolean isValid = false;
    private int channels;
    private int sampleRate;
    private int bytesPerSecond;
    private int bitrate;

    public WavFormatHeader(byte[] b) {
        String fmt = new String(b, 0, 3);
        if (fmt.equals("fmt") && b[8] == 1) {
            this.channels = b[10];
            this.sampleRate = this.u(b[15]) * 0x1000000 + this.u(b[14]) * 65536 + this.u(b[13]) * 256 + this.u(b[12]);
            this.bytesPerSecond = this.u(b[19]) * 0x1000000 + this.u(b[18]) * 65536 + this.u(b[17]) * 256 + this.u(b[16]);
            this.bitrate = this.u(b[22]);
            this.isValid = true;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }

    public int getChannelNumber() {
        return this.channels;
    }

    public int getSamplingRate() {
        return this.sampleRate;
    }

    public int getBytesPerSecond() {
        return this.bytesPerSecond;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    private int u(int n) {
        return n & 0xFF;
    }

    public String toString() {
        String out = "RIFF-WAVE Header:\n";
        out = out + "Is valid?: " + this.isValid;
        return out;
    }
}

