/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class LazyTransactionManager
implements TransactionManager {
    protected TransactionManager transactionManager;

    protected TransactionManager getTransactionManager() {
        if (this.transactionManager == null) {
            try {
                this.transactionManager = TransactionHelper.lookupTransactionManager();
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
        }
        return this.transactionManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getTransactionManager().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getTransactionManager().commit();
    }

    public int getStatus() throws SystemException {
        return this.getTransactionManager().getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return this.getTransactionManager().getTransaction();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        this.getTransactionManager().resume(tobj);
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getTransactionManager().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getTransactionManager().setTransactionTimeout(seconds);
    }

    public Transaction suspend() throws SystemException {
        return this.getTransactionManager().suspend();
    }
}

