/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.util.HashMap;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.DataSourceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@XObject(value="datasource")
public class DataSourceDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="")
    public Element element;
    @XNodeMap(value="property", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> properties;
    protected Reference reference;

    public Reference getReference() {
        if (this.reference == null) {
            String value;
            String name;
            this.reference = new Reference(DataSource.class.getName(), DataSourceFactory.class.getName(), null);
            NamedNodeMap attrs = this.element.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attr = attrs.item(i);
                name = attr.getNodeName();
                if ("name".equals(name)) continue;
                value = Framework.expandVars((String)attr.getNodeValue());
                this.reference.add(new StringRefAddr(name, value));
            }
            for (Map.Entry<String, String> e : this.properties.entrySet()) {
                name = e.getKey();
                value = Framework.expandVars((String)e.getValue());
                this.reference.add(new StringRefAddr(name, value));
            }
        }
        return this.reference;
    }
}

