/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityReply;

@Entity(name="Activity")
@Table(name="nxp_activities")
public class ActivityImpl
implements Activity {
    private static final Log log = LogFactory.getLog(ActivityImpl.class);
    private Long id;
    private String actor;
    private String displayActor;
    private String verb;
    private String object;
    private String displayObject;
    private String target;
    private String displayTarget;
    private String context;
    private Date publishedDate;
    private Date lastUpdatedDate;
    private String replies;

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(nullable=false, columnDefinition="integer")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column
    public String getActor() {
        return this.actor;
    }

    @Override
    public void setActor(String actor) {
        this.actor = actor;
    }

    @Override
    @Column
    public String getDisplayActor() {
        return this.displayActor;
    }

    @Override
    public void setDisplayActor(String displayActor) {
        this.displayActor = displayActor;
    }

    @Override
    @Column
    public String getVerb() {
        return this.verb;
    }

    @Override
    public void setVerb(String verb) {
        this.verb = verb;
    }

    @Override
    @Column
    public String getObject() {
        return this.object;
    }

    @Override
    public void setObject(String object) {
        this.object = object;
    }

    @Override
    @Column
    public String getDisplayObject() {
        return this.displayObject;
    }

    @Override
    public void setDisplayObject(String displayObject) {
        this.displayObject = displayObject;
    }

    @Override
    @Column
    public String getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(String target) {
        this.target = target;
    }

    @Override
    @Column
    public String getDisplayTarget() {
        return this.displayTarget;
    }

    @Override
    public void setDisplayTarget(String displayTarget) {
        this.displayTarget = displayTarget;
    }

    @Override
    @Column
    public String getContext() {
        return this.context;
    }

    @Override
    public void setContext(String context) {
        this.context = context;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    public Date getPublishedDate() {
        return this.publishedDate;
    }

    @Override
    public void setPublishedDate(Date publishedDate) {
        this.publishedDate = publishedDate;
    }

    @Override
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column
    public Date getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    @Override
    public void setLastUpdatedDate(Date lastUpdated) {
        this.lastUpdatedDate = lastUpdated;
    }

    @Override
    @Column
    @Lob
    public String getReplies() {
        return this.replies;
    }

    @Override
    public void setReplies(String replies) {
        this.replies = replies;
    }

    @Override
    @Transient
    public List<ActivityReply> getActivityReplies() {
        if (this.replies == null) {
            return new ArrayList<ActivityReply>();
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            return (List)mapper.readValue(this.replies, (TypeReference)new TypeReference<List<ActivityReply>>(){});
        }
        catch (Exception e) {
            log.warn((Object)String.format("Unable to convert replies to ActivityReply: %s", e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            return new ArrayList<ActivityReply>();
        }
    }

    @Override
    public void setActivityReplies(List<ActivityReply> activityReplies) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            StringWriter writer = new StringWriter();
            mapper.writeValue((Writer)writer, activityReplies);
            this.replies = writer.toString();
        }
        catch (Exception e) {
            log.warn((Object)String.format("Unable to convert replies to ActivityReply: %s", e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
    }

    @Override
    public Map<String, String> toMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("id", String.valueOf(this.id));
        m.put("actor", this.actor);
        m.put("displayActor", this.displayActor);
        m.put("object", this.object);
        m.put("displayObject", this.displayObject);
        m.put("target", this.target);
        m.put("displayTarget", this.displayTarget);
        m.put("verb", this.verb);
        m.put("context", this.context);
        m.put("publishedDate", this.publishedDate.toString());
        m.put("lastUpdatedDate", this.lastUpdatedDate != null ? this.lastUpdatedDate.toString() : null);
        m.put("replies", this.replies);
        return Collections.unmodifiableMap(m);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

