/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audio.extension;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.framebody.FrameBodyAPIC;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailFactory;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;

public class ThumbnailAudioFactory
implements ThumbnailFactory {
    private static final Log log = LogFactory.getLog(ThumbnailAudioFactory.class);

    public Blob getThumbnail(DocumentModel doc, CoreSession session) throws ClientException {
        if (!doc.hasFacet("Audio")) {
            throw new ClientException("Document is not audio type");
        }
        Blob thumbnailBlob = null;
        try {
            if (doc.hasFacet("Thumbnail")) {
                thumbnailBlob = (Blob)doc.getPropertyValue("thumb:thumbnail");
            }
        }
        catch (ClientException e) {
            log.warn((Object)"Could not fetch the thumbnail blob", (Throwable)e);
        }
        if (thumbnailBlob == null) {
            TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
            return new FileBlob(FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + docType.getBigIcon())));
        }
        return thumbnailBlob;
    }

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        FileBlob thumbnailBlob = null;
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        try {
            FileBlob fileBlob = new FileBlob(bh.getBlob().getStream());
            MP3File file = new MP3File(fileBlob.getFile());
            if (file.hasID3v2Tag()) {
                ID3v23Frame id3v2 = (ID3v23Frame)file.getID3v2Tag().getFrameOfType("APIC").next();
                FrameBodyAPIC framePic = (FrameBodyAPIC)id3v2.getBody();
                ByteArrayInputStream is = new ByteArrayInputStream(framePic.getImageData());
                thumbnailBlob = new FileBlob((InputStream)is);
            }
        }
        catch (IOException | InvalidAudioFrameException | ReadOnlyFileException | TagException | ClientException e) {
            log.warn((Object)"Unable to get the audio file cover art", e);
        }
        return thumbnailBlob;
    }
}

