/*
 * (C) Copyright 2006-2010 Nuxeo SAS (http://nuxeo.com/) and contributors.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser General Public License
 * (LGPL) version 2.1 which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * Contributors:
 *     bstefanescu
 */
package org.nuxeo.gwt.habyt.upload.client.core;


import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;

/**
 * An input file with an optional custom widget to be rendered in the place of
 * the input file. If the custom widget is defined it will be showed in the UI
 * and the input file will be hidden. Clicks on the custom widget will be
 * redirected to the input file to show the File Browser.
 * 
 * This widget will be set as the form content that will be used for the upload.
 * 
 * @author <a href="mailto:bs@nuxeo.com">Bogdan Stefanescu</a>
 * 
 */
public class InputFileWrapper extends FlowPanel {

    public static InputFileWrapper create() {
        HijackStrategy hs = GWT.create(HijackStrategy.class);
        return hs.getWrapper();
    }

    protected Widget widget;

    protected FileUpload fu;

    public InputFileWrapper() {
        setStyleName("file-input-wrapper");
        this.fu = new FileUpload();
        fu.setName("file");
        add(fu);
    }

    /**
     * Get the wrapped file upload widget.
     * 
     * @return
     */
    public FileUpload getFileUpload() {
        return fu;
    }

    /**
     * Set the widget that should be shown instead of the input file widget. The
     * given widget cannot be null otherwise an exception is thrown. If this
     * method is not called to set a custom widget the input file widget will be
     * shown.
     * 
     * @param w the widget to be shown instead of the file input. Cannot be
     *            null.
     */
    public void setVisibleWidget(Widget w) {
        if (w == null) {
            throw new IllegalArgumentException(
                    "Custom file widget cannot be null");
        }
        this.widget = w;
        add(w);
    }

    /**
     * Get the visible widget if any was set otherwise return null.
     * 
     * @return
     */
    public Widget getVisibleWidget() {
        return widget;
    }

    /**
     * Called by the form when the widget is no more shown (wrapping is no more
     * needed). This usually happens after a submit. In that case the widget
     * should free any registration handlers or resources it is using.
     * 
     * Note that is not the same as {@link #onUnload()} since the input file is
     * still used in the background until the submission ends.
     * 
     * Note that this method may be called twice so the wrapper should ignore
     * subsequent calls on this method if already disposed. (i.e the first time
     * when form is removed from the visible area and the second time when
     * upload is canceled or done)
     */
    public void dispose() {
    }

}
