/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.dam;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.dam.AllowedAssetTypeDescriptor;
import org.nuxeo.dam.AllowedAssetTypeRegistry;
import org.nuxeo.dam.AssetLibrary;
import org.nuxeo.dam.DamService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DamServiceImpl
extends DefaultComponent
implements DamService {
    public static final String ASSET_LIBRARY_EP = "assetLibrary";
    public static final String ALLOWED_ASSET_TYPES_EP = "allowedAssetTypes";
    protected AssetLibrary assetLibrary;
    protected AllowedAssetTypeRegistry allowedAssetTypeRegistry;

    public void activate(ComponentContext context) throws Exception {
        this.allowedAssetTypeRegistry = new AllowedAssetTypeRegistry();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.allowedAssetTypeRegistry = null;
    }

    @Override
    public AssetLibrary getAssetLibrary() {
        return this.assetLibrary;
    }

    @Override
    public List<Type> getAllowedAssetTypes() {
        TypeManager typeManager = (TypeManager)Framework.getLocalService(TypeManager.class);
        List<String> docTypes = this.allowedAssetTypeRegistry.getAllowedAssetTypes();
        ArrayList<Type> types = new ArrayList<Type>();
        for (String docType : docTypes) {
            Type type = typeManager.getType(docType);
            if (type == null) continue;
            types.add(type);
        }
        return types;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ASSET_LIBRARY_EP.equals(extensionPoint)) {
            this.assetLibrary = (AssetLibrary)contribution;
        } else if (ALLOWED_ASSET_TYPES_EP.equals(extensionPoint)) {
            this.allowedAssetTypeRegistry.addContribution((AllowedAssetTypeDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ASSET_LIBRARY_EP.equals(extensionPoint)) {
            this.assetLibrary = null;
        } else if (ALLOWED_ASSET_TYPES_EP.equals(extensionPoint)) {
            this.allowedAssetTypeRegistry.removeContribution((AllowedAssetTypeDescriptor)contribution);
        }
    }
}

