/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import org.apache.shindig.config.ContainerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentRewriterUris {
    private final ContainerConfig config;
    private final String proxyBaseNoGadget;
    private final String concatBaseNoGadget;
    static final String PROXY_BASE_CONFIG_PROPERTY = "gadgets.rewriteProxyBase";
    static final String CONCAT_BASE_CONFIG_PROPERTY = "gadgets.rewriteConcatBase";

    @Inject
    public ContentRewriterUris(ContainerConfig config, @Named(value="shindig.content-rewrite.proxy-url") String proxyBaseNoGadget, @Named(value="shindig.content-rewrite.concat-url") String concatBaseNoGadget) {
        this.config = config;
        this.proxyBaseNoGadget = proxyBaseNoGadget;
        this.concatBaseNoGadget = concatBaseNoGadget;
    }

    public String getProxyBase(String container) {
        container = ContentRewriterUris.firstNonNull(container, "default");
        return ContentRewriterUris.firstNonNull(this.config.getString(container, PROXY_BASE_CONFIG_PROPERTY), this.proxyBaseNoGadget);
    }

    public String getConcatBase(String container) {
        container = ContentRewriterUris.firstNonNull(container, "default");
        return ContentRewriterUris.firstNonNull(this.config.getString(container, CONCAT_BASE_CONFIG_PROPERTY), this.concatBaseNoGadget);
    }

    private static <T> T firstNonNull(T first, T second) {
        return (T)(first != null ? first : Preconditions.checkNotNull(second));
    }
}

