/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.internal.ImmutableMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLEntities;
import org.cyberneko.html.HTMLScanner;
import org.cyberneko.html.HTMLTagBalancer;
import org.cyberneko.html.filters.NamespaceBinder;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class NekoSimplifiedHtmlParser
extends GadgetHtmlParser {
    private static final HTMLElements.Element OSML_TEMPLATE_ELEMENT;
    private static final HTMLElements.Element OSML_DATA_ELEMENT;
    private static final Map<String, HTMLElements.Element> OSML_ELEMENTS;
    private final DOMImplementation documentFactory;

    @Inject
    public NekoSimplifiedHtmlParser(DOMImplementation documentFactory) {
        this.documentFactory = documentFactory;
    }

    protected Document parseDomImpl(String source) throws GadgetException {
        DocumentHandler handler;
        HTMLConfiguration config = this.newConfiguration();
        try {
            handler = this.parseHtmlImpl(source, config, new NormalizingTagBalancer());
        }
        catch (IOException ioe) {
            return null;
        }
        Document document = handler.getDocument();
        DocumentFragment fragment = handler.getFragment();
        this.normalizeFragment(document, fragment);
        return document;
    }

    protected DocumentFragment parseFragmentImpl(String source) throws GadgetException {
        DocumentHandler handler;
        HTMLConfiguration config = this.newConfiguration();
        config.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        config.setProperty("http://cyberneko.org/html/properties/balance-tags/fragment-context-stack", (Object)new QName[]{new QName(null, "HTML", "HTML", null), new QName(null, "BODY", "BODY", null)});
        try {
            handler = this.parseHtmlImpl(source, config, new NekoPatchTagBalancer());
        }
        catch (IOException ioe) {
            return null;
        }
        return handler.getFragment();
    }

    private DocumentHandler parseHtmlImpl(String source, HTMLConfiguration config, NormalizingTagBalancer tagBalancer) throws IOException {
        HTMLScanner htmlScanner = new HTMLScanner();
        tagBalancer.setScanner(htmlScanner);
        DocumentHandler handler = this.newDocumentHandler(source);
        NamespaceBinder namespaceBinder = new NamespaceBinder();
        namespaceBinder.setDocumentHandler((XMLDocumentHandler)handler);
        namespaceBinder.setDocumentSource((XMLDocumentSource)tagBalancer);
        namespaceBinder.reset((XMLComponentManager)config);
        tagBalancer.setDocumentHandler((XMLDocumentHandler)namespaceBinder);
        tagBalancer.setDocumentSource((XMLDocumentSource)htmlScanner);
        htmlScanner.setDocumentHandler((XMLDocumentHandler)tagBalancer);
        tagBalancer.reset((XMLComponentManager)config);
        htmlScanner.reset((XMLComponentManager)config);
        XMLInputSource inputSource = new XMLInputSource(null, null, null);
        inputSource.setEncoding("UTF-8");
        inputSource.setCharacterStream((Reader)new StringReader(source));
        htmlScanner.setInputSource(inputSource);
        htmlScanner.scanDocument(true);
        return handler;
    }

    protected HTMLConfiguration newConfiguration() {
        HTMLConfiguration config = new HTMLConfiguration();
        config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        config.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
        config.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
        config.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
        config.setFeature("http://xml.org/sax/features/namespaces", true);
        return config;
    }

    protected DocumentHandler newDocumentHandler(String source) {
        return new DocumentHandler(source);
    }

    static {
        HTMLElements.Element unknown = HTMLElements.getElement((short)117);
        OSML_TEMPLATE_ELEMENT = new HTMLElements.Element(unknown.code, "OSTemplate", unknown.flags, 14, unknown.closes);
        NekoSimplifiedHtmlParser.OSML_TEMPLATE_ELEMENT.parent = new HTMLElements.Element[]{HTMLElements.getElement((short)14)};
        OSML_DATA_ELEMENT = new HTMLElements.Element(unknown.code, "OSTemplate", unknown.flags, 14, unknown.closes);
        NekoSimplifiedHtmlParser.OSML_DATA_ELEMENT.parent = new HTMLElements.Element[]{HTMLElements.getElement((short)14)};
        OSML_ELEMENTS = ImmutableMap.of((Object)"OSTemplate", (Object)OSML_TEMPLATE_ELEMENT, (Object)"OSData", (Object)OSML_DATA_ELEMENT);
    }

    private class NormalizingTagBalancer
    extends HTMLTagBalancer {
        private StringBuilder scriptContent;
        private HTMLScanner scanner;
        private QName currentOsmlTag;

        public void setScanner(HTMLScanner scanner) {
            this.scanner = scanner;
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.currentOsmlTag != null) {
                this.scriptContent.append(text.ch, text.offset, text.length);
            } else {
                super.characters(text, augs);
            }
        }

        public void startElement(QName elem, XMLAttributes attrs, Augmentations augs) throws XNIException {
            String value;
            String osmlTagName;
            if (!this.fSeenRootElement && elem.rawname.equalsIgnoreCase("html")) {
                elem.localpart = "html";
                elem.rawname = "html";
            } else if (!this.fSeenHeadElement && elem.rawname.equalsIgnoreCase("head")) {
                elem.localpart = "head";
                elem.rawname = "head";
            } else if (!this.fSeenBodyElement && elem.rawname.equalsIgnoreCase("body")) {
                elem.localpart = "body";
                elem.rawname = "body";
            }
            if ("script".equalsIgnoreCase(elem.rawname) && (osmlTagName = (String)GadgetHtmlParser.SCRIPT_TYPE_TO_OSML_TAG.get((Object)(value = attrs.getValue("type")))) != null) {
                if (this.currentOsmlTag != null) {
                    throw new XNIException("Nested OpenSocial script elements");
                }
                this.currentOsmlTag = new QName(null, osmlTagName, osmlTagName, null);
                if (this.scriptContent == null) {
                    this.scriptContent = new StringBuilder();
                }
                attrs.removeAttributeAt(attrs.getIndex("type"));
                super.startElement(this.currentOsmlTag, attrs, augs);
                return;
            }
            super.startElement(elem, attrs, augs);
        }

        public void endElement(QName element, Augmentations augs) throws XNIException {
            if (this.currentOsmlTag != null && "script".equalsIgnoreCase(element.rawname)) {
                QName endingTag = this.currentOsmlTag;
                this.currentOsmlTag = null;
                XMLInputSource scriptSource = new XMLInputSource(null, null, null);
                scriptSource.setCharacterStream((Reader)new StringReader(this.scriptContent.toString()));
                this.scriptContent.setLength(0);
                this.scanner.evaluateInputSource(scriptSource);
                super.endElement(endingTag, augs);
            } else {
                super.endElement(element, augs);
            }
        }

        protected HTMLElements.Element getElement(QName elementName) {
            HTMLElements.Element osmlElement = (HTMLElements.Element)OSML_ELEMENTS.get(elementName.localpart);
            if (osmlElement != null) {
                return osmlElement;
            }
            return super.getElement(elementName);
        }
    }

    private class NekoPatchTagBalancer
    extends NormalizingTagBalancer {
        private NekoPatchTagBalancer() {
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext nscontext, Augmentations augs) throws XNIException {
            super.startDocument(locator, encoding, nscontext, augs);
            for (int i = this.fElementStack.top - 1; i >= 0; --i) {
                this.fSeenAnything = true;
                if (this.fElementStack.data[i].element.code == 46) {
                    this.fSeenRootElement = true;
                }
                if (this.fElementStack.data[i].element.code == 44) {
                    this.fSeenHeadElement = true;
                }
                if (this.fElementStack.data[i].element.code != 14) continue;
                this.fSeenBodyElement = true;
            }
        }
    }

    protected class DocumentHandler
    implements XMLDocumentHandler {
        private final Stack<Node> elementStack = new Stack();
        private final StringBuilder builder;
        private boolean inEntity = false;
        private DocumentFragment documentFragment;
        private Document document;

        public DocumentHandler(String content) {
            this.builder = new StringBuilder(content.length() / 10);
        }

        public DocumentFragment getFragment() {
            return this.documentFragment;
        }

        public Document getDocument() {
            return this.document;
        }

        public void startDocument(XMLLocator xmlLocator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            this.document = NekoSimplifiedHtmlParser.this.documentFactory.createDocument(null, null, null);
            this.elementStack.clear();
            this.documentFragment = this.document.createDocumentFragment();
            this.elementStack.push(this.documentFragment);
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            this.builder.append("<?xml");
            if (version != null) {
                this.builder.append(" version=\"").append(version).append('\"');
            }
            if (encoding != null) {
                this.builder.append(" encoding=\"").append(encoding).append('\"');
            }
            if (standalone != null) {
                this.builder.append(" standalone=\"").append(standalone).append('\"');
            }
            this.builder.append('>');
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            this.document = NekoSimplifiedHtmlParser.this.documentFactory.createDocument(null, null, NekoSimplifiedHtmlParser.this.documentFactory.createDocumentType(rootElement, publicId, systemId));
            this.elementStack.clear();
            this.documentFragment = this.document.createDocumentFragment();
            this.elementStack.push(this.documentFragment);
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            this.flushTextBuffer();
            Comment comment = this.getDocument().createComment(new String(text.ch, text.offset, text.length));
            this.appendChild(comment);
        }

        public void processingInstruction(String s, XMLString xmlString, Augmentations augs) throws XNIException {
        }

        public void startElement(QName qName, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            Element element = this.startElementImpl(qName, xmlAttributes);
            this.elementStack.push(element);
        }

        public void emptyElement(QName qName, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            this.startElementImpl(qName, xmlAttributes);
        }

        protected void flushTextBuffer() {
            if (this.builder.length() > 0) {
                this.appendChild(this.document.createTextNode(this.builder.toString()));
                this.builder.setLength(0);
            }
        }

        private Element startElementImpl(QName qName, XMLAttributes xmlAttributes) {
            this.flushTextBuffer();
            Element element = qName.uri != null ? this.document.createElementNS(qName.uri, qName.rawname) : this.document.createElement(qName.rawname);
            for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                if (xmlAttributes.getURI(i) != null) {
                    element.setAttributeNS(xmlAttributes.getURI(i), xmlAttributes.getQName(i), xmlAttributes.getValue(i));
                    continue;
                }
                try {
                    element.setAttribute(xmlAttributes.getLocalName(i), xmlAttributes.getValue(i));
                    continue;
                }
                catch (DOMException e) {
                    switch (e.code) {
                        case 5: {
                            StringBuilder sb = new StringBuilder(e.getMessage());
                            sb.append("Around ...<");
                            if (qName.prefix != null) {
                                sb.append(qName.prefix);
                                sb.append(":");
                            }
                            sb.append(qName.localpart);
                            for (int j = 0; j < xmlAttributes.getLength(); ++j) {
                                if (!StringUtils.isNotBlank((String)xmlAttributes.getLocalName(j)) || !StringUtils.isNotBlank((String)xmlAttributes.getValue(j))) continue;
                                sb.append(' ');
                                sb.append(xmlAttributes.getLocalName(j));
                                sb.append("=\"");
                                sb.append(xmlAttributes.getValue(j)).append('\"');
                            }
                            sb.append("...");
                            throw new DOMException(5, sb.toString());
                        }
                    }
                    throw e;
                }
            }
            this.appendChild(element);
            return element;
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
            if (name.startsWith("#")) {
                try {
                    boolean hex = name.startsWith("#x");
                    int offset = hex ? 2 : 1;
                    int base = hex ? 16 : 10;
                    int value = Integer.parseInt(name.substring(offset), base);
                    String entity = HTMLEntities.get((int)value);
                    if (entity != null) {
                        name = entity;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.printEntity(name);
            this.inEntity = true;
        }

        private void printEntity(String name) {
            this.builder.append('&');
            this.builder.append(name);
            this.builder.append(';');
        }

        public void textDecl(String s, String s1, Augmentations augs) throws XNIException {
            this.builder.append(s);
        }

        public void endGeneralEntity(String s, Augmentations augs) throws XNIException {
            this.inEntity = false;
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (this.inEntity) {
                return;
            }
            this.builder.append(text.ch, text.offset, text.length);
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            this.builder.append(text.ch, text.offset, text.length);
        }

        public void endElement(QName qName, Augmentations augs) throws XNIException {
            this.flushTextBuffer();
            this.elementStack.pop();
        }

        public void startCDATA(Augmentations augs) throws XNIException {
        }

        public void endCDATA(Augmentations augs) throws XNIException {
        }

        public void endDocument(Augmentations augs) throws XNIException {
            this.flushTextBuffer();
            this.elementStack.pop();
        }

        public void setDocumentSource(XMLDocumentSource xmlDocumentSource) {
        }

        public XMLDocumentSource getDocumentSource() {
            return null;
        }

        private void appendChild(Node node) {
            this.elementStack.peek().appendChild(node);
        }
    }
}

