/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;

public class XMLBeanInfo {
    private ElementDescriptor elementDescriptor;
    private Class beanClass;
    private String idAttributeName = "id";
    private String idrefAttributeName = "idref";
    private boolean cachedIDAttribute = false;
    private AttributeDescriptor idAttributeDescriptor;

    public XMLBeanInfo(Class beanClass) {
        this.beanClass = beanClass;
    }

    public ElementDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public void setElementDescriptor(ElementDescriptor elementDescriptor) {
        this.elementDescriptor = elementDescriptor;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this.beanClass = beanClass;
    }

    public AttributeDescriptor getIDAttribute() {
        this.idAttributeDescriptor = this.findIDAttribute();
        return this.idAttributeDescriptor;
    }

    private AttributeDescriptor findIDAttribute() {
        AttributeDescriptor[] attributes;
        if (this.getElementDescriptor().hasAttributes() && (attributes = this.getElementDescriptor().getAttributeDescriptors()) != null) {
            int size = attributes.length;
            for (int i = 0; i < size; ++i) {
                if (!this.getIDAttributeName().equals(attributes[i].getQualifiedName()) && !this.getIDAttributeName().equals(attributes[i].getLocalName())) continue;
                return attributes[i];
            }
        }
        return null;
    }

    public String getIDAttributeName() {
        return this.idAttributeName;
    }

    public void setIDAttributeName(String idAttributeName) {
        this.idAttributeName = idAttributeName;
    }

    public String getIDREFAttributeName() {
        return this.idrefAttributeName;
    }

    public void setIDREFAttributeName(String idrefAttributeName) {
        this.idrefAttributeName = idrefAttributeName;
    }

    public String toString() {
        return "XMLBeanInfo [class=" + this.getBeanClass() + ", descriptor=" + this.getElementDescriptor() + "]";
    }
}

