/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol;

import com.google.common.base.Objects;

public final class ResponseItem {
    private final int errorCode;
    private final String errorMessage;
    private final Object response;

    public ResponseItem(int errorCode, String errorMessage) {
        this(errorCode, errorMessage, null);
    }

    public ResponseItem(int errorCode, String errorMessage, Object response) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.response = response;
    }

    public ResponseItem(Object response) {
        this.errorCode = 200;
        this.errorMessage = null;
        this.response = response;
    }

    public Object getResponse() {
        return this.response;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponseItem)) {
            return false;
        }
        ResponseItem that = (ResponseItem)o;
        return this.errorCode == that.errorCode && Objects.equal((Object)this.errorMessage, (Object)that.errorMessage) && Objects.equal((Object)this.response, (Object)that.response);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.errorCode, this.errorMessage, this.response});
    }
}

