/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.video.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.video.TranscodedVideo;
import org.nuxeo.ecm.platform.video.Video;
import org.nuxeo.ecm.platform.video.VideoDocument;
import org.nuxeo.ecm.platform.video.service.VideoConversionId;
import org.nuxeo.ecm.platform.video.service.VideoService;
import org.nuxeo.runtime.api.Framework;

public class VideoConversionWork
extends AbstractWork {
    private static final Log log = LogFactory.getLog(VideoConversionWork.class);
    public static final String CATEGORY_VIDEO_CONVERSION = "videoConversion";
    protected final VideoConversionId id;

    public VideoConversionWork(VideoConversionId id) {
        this.id = id;
    }

    public String getCategory() {
        return CATEGORY_VIDEO_CONVERSION;
    }

    public String getTitle() {
        return "Video Conversion " + this.id.getConversionName();
    }

    public void work() throws ClientException {
        this.setStatus("Extracting");
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        Video originalVideo = this.getVideoToConvert();
        if (originalVideo != null) {
            this.commitOrRollbackTransaction();
            VideoService service = (VideoService)Framework.getLocalService(VideoService.class);
            String conversionName = this.id.getConversionName();
            this.setStatus("Transcoding");
            TranscodedVideo transcodedVideo = service.convert(this.id, originalVideo, conversionName);
            this.startTransaction();
            this.setStatus("Saving");
            this.saveNewTranscodedVideo(transcodedVideo);
        }
        this.setStatus(null);
    }

    protected Video getVideoToConvert() throws ClientException {
        final Video[] videos = new Video[1];
        final DocumentRef docRef = this.id.getDocumentLocation().getDocRef();
        String repositoryName = this.id.getDocumentLocation().getServerName();
        new UnrestrictedSessionRunner(repositoryName){

            public void run() throws ClientException {
                Video video;
                DocumentModel doc = this.session.getDocument(docRef);
                VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class);
                videos[0] = video = videoDocument.getVideo();
                if (video == null) {
                    log.warn((Object)("No original video to transcode for: " + doc));
                }
            }
        }.runUnrestricted();
        return videos[0];
    }

    protected void saveNewTranscodedVideo(final TranscodedVideo transcodedVideo) throws ClientException {
        final DocumentRef docRef = this.id.getDocumentLocation().getDocRef();
        String repositoryName = this.id.getDocumentLocation().getServerName();
        new UnrestrictedSessionRunner(repositoryName){

            public void run() throws ClientException {
                DocumentModel doc = this.session.getDocument(docRef);
                ArrayList<Map> transcodedVideos = (ArrayList<Map>)doc.getPropertyValue("vid:transcodedVideos");
                if (transcodedVideos == null) {
                    transcodedVideos = new ArrayList<Map>();
                }
                transcodedVideos.add(transcodedVideo.toMap());
                doc.setPropertyValue("vid:transcodedVideos", (Serializable)transcodedVideos);
                this.session.saveDocument(doc);
                this.session.save();
            }
        }.runUnrestricted();
    }

    public boolean equals(Object other) {
        if (!(other instanceof VideoConversionWork)) {
            return false;
        }
        return this.id.equals((Object)((VideoConversionWork)((Object)other)).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

