/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.html;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Attr;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AttributesImpl
implements Attributes {
    private final List<Attr> attribs;
    static final AttributesImpl NONE = new AttributesImpl(Collections.<Attr>emptyList());

    AttributesImpl(List<Attr> attribs) {
        this.attribs = attribs;
    }

    @Override
    public int getIndex(String qName) {
        int index = 0;
        for (Attr attrib : this.attribs) {
            if (attrib.getName().equals(qName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int getIndex(String uri, String localName) {
        int index = 0;
        for (Attr attrib : this.attribs) {
            if ((uri == null ? attrib.getNamespaceURI() == null : uri.equals(attrib.getNamespaceURI())) && attrib.getLocalName().equals(localName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public int getLength() {
        return this.attribs.size();
    }

    @Override
    public String getLocalName(int index) {
        return this.attribs.get(index).getLocalName();
    }

    @Override
    public String getQName(int index) {
        return this.attribs.get(index).getName();
    }

    @Override
    public String getType(int index) {
        return null;
    }

    @Override
    public String getType(String qName) {
        return null;
    }

    @Override
    public String getType(String uri, String localName) {
        return null;
    }

    @Override
    public String getURI(int index) {
        return this.attribs.get(index).getNamespaceURI();
    }

    @Override
    public String getValue(int index) {
        return this.attribs.get(index).getValue();
    }

    @Override
    public String getValue(String qName) {
        int index = this.getIndex(qName);
        return index < 0 ? null : this.getValue(index);
    }

    @Override
    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index < 0 ? null : this.getValue(index);
    }

    public List<Attr> getAttributes() {
        return Collections.unmodifiableList(this.attribs);
    }
}

