/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.services;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import java.io.File;
import java.lang.annotation.Annotation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.services.FakeNuxeoDataStore;
import org.nuxeo.opensocial.shindig.crypto.NXBlobCrypterSecurityTokenDecoder;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCryptoModule
extends AbstractModule {
    private static final Log LOG = LogFactory.getLog(NuxeoCryptoModule.class);

    protected final void configure() {
        try {
            this.bind(SecurityTokenDecoder.class).to(NXBlobCrypterSecurityTokenDecoder.class);
            this.bind(OAuthDataStore.class).to(FakeNuxeoDataStore.class);
            OpenSocialService oss = (OpenSocialService)Framework.getService(OpenSocialService.class);
            File signingKeyFile = oss.getSigningStateKeyFile();
            if (signingKeyFile == null) {
                LOG.warn((Object)"OAuth keys not properly configured, existing NuxeoCryptoModule");
                return;
            }
            String callbackUrl = oss.getOAuthCallbackUrl();
            String signingKeyPath = signingKeyFile.getPath();
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.signing.state-key")).toInstance((Object)signingKeyPath);
            this.bind(String.class).annotatedWith((Annotation)Names.named((String)"shindig.signing.global-callback-url")).toInstance((Object)callbackUrl);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to bind Shindig services to Nuxeo components", (Throwable)e);
        }
    }
}

