/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.render.AbstractRenderer;
import com.google.caja.render.TokenClassification;

public final class CssMinimalPrinter
extends AbstractRenderer {
    private int charInLine;
    private char lastToken = '\u0000';
    private char pendingSpace = '\u0000';

    public CssMinimalPrinter(TokenConsumer out) {
        super(out);
    }

    public void mark(FilePosition pos) {
        this.out.mark(pos);
    }

    public void consume(String text) {
        TokenClassification tClass = TokenClassification.classify(text);
        if (tClass == null) {
            return;
        }
        switch (tClass) {
            case LINEBREAK: {
                if (this.pendingSpace == '\n') {
                    this.newLine();
                }
                this.pendingSpace = (char)10;
                return;
            }
            case SPACE: {
                if (this.pendingSpace != '\n' && this.lastToken != ':') {
                    this.pendingSpace = (char)32;
                }
                return;
            }
        }
        char spaceBefore = this.pendingSpace;
        this.pendingSpace = '\u0000';
        if (text.length() == 1) {
            char ch0 = text.charAt(0);
            switch (ch0) {
                case ',': 
                case ':': 
                case ';': 
                case '{': 
                case '}': {
                    spaceBefore = '\u0000';
                }
            }
            this.lastToken = ch0;
        } else {
            this.lastToken = '\u0000';
        }
        switch (spaceBefore) {
            case '\n': {
                this.newLine();
                break;
            }
            case ' ': {
                this.space();
            }
        }
        this.emit(text);
    }

    private void newLine() {
        if (this.charInLine == 0) {
            return;
        }
        this.charInLine = 0;
        this.out.consume("\n");
    }

    private void space() {
        if (this.charInLine != 0) {
            this.out.consume(" ");
            ++this.charInLine;
        }
    }

    private void emit(String s) {
        int n;
        this.out.consume(s);
        int i = n = s.length();
        while (--i >= 0) {
            char ch = s.charAt(i);
            if (ch != '\r' && ch != '\n') continue;
            this.charInLine = n - i;
            break;
        }
        this.charInLine += n;
    }
}

